package com.jz.website.repository;

import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jooq.website.Tables;
import com.jz.jooq.website.tables.pojos.NewsInfo;

@Lazy
@Repository
public class NewsInfoRepository extends WebsiteBaseRepository {

	private static final com.jz.jooq.website.tables.NewsInfo NI = Tables.NEWS_INFO;
	private static final com.jz.jooq.website.tables.NewsSchool NS = Tables.NEWS_SCHOOL;

	private Condition getCondition(String school, Integer tid, String title) {
		Condition condition = NS.SCHOOL_ID.eq(school).and(NS.TID.eq(tid)).and(NS.STATUS.eq(1));
		if (StringTools.isNotEmptyAndBlank(title))
			condition = condition.and(NS.TITLE.like("%" + title + "%"));
		return condition;
	}

	public int cntNews(String school, Integer tid, String title) {
		return websiteCtx.fetchCount(NS, getCondition(school, tid, title));
	}

	public List<String> getNewsId(String school, Integer tid, String title, int start, int size) {
		// 0未发布 1已发布 2取消发布 -1删除
		return websiteCtx.select(NS.NID).from(NS).where(getCondition(school, tid, title)).orderBy(NS.CREATE_TIME.desc())
				.limit(start, size).fetchInto(String.class);
	}

	public List<NewsInfo> getListNewsInfo(List<String> nids) {
		return websiteCtx.select(NI.ID, NI.SCHOOL_ID, NI.TITLE, NI.PIC, NI.CREATE_TIME).from(NI).where(NI.ID.in(nids))
				.orderBy(NI.CREATE_TIME.desc()).fetchInto(NewsInfo.class);
	}

	public NewsInfo getNewsInfo(String nid) {
		return ArrayMapTools.getFirst(websiteCtx.selectFrom(NI).where(NI.ID.eq(nid)).fetchInto(NewsInfo.class));
	}

	public List<NewsInfo> getBannerNewsInfo(List<String> nids) {
		return websiteCtx.select(NI.ID, NI.TITLE, NI.BANNER_PIC).from(NI).where(NI.ID.in(nids))
				.fetchInto(NewsInfo.class);
	}

	public List<String> getNewsId(String school) {
		// 0未发布 1已发布 2取消发布 -1删除
		return websiteCtx.select(NS.NID).from(NS).where(NS.SCHOOL_ID.eq(school).and(NS.STATUS.eq(1)))
				.orderBy(NS.CREATE_TIME.desc()).fetchInto(String.class);
	}
}
