package com.jz.website.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.website.Tables;
import com.jz.jooq.website.tables.pojos.SchoolIntro;

@Lazy
@Repository
public class SchoolIntroRepository extends WebsiteBaseRepository {

	private static final com.jz.jooq.website.tables.SchoolIntro SI = Tables.SCHOOL_INTRO;

	public SchoolIntro getSchoolIntro(String schoolId) {
		return websiteCtx.selectFrom(SI).where(SI.SCHOOL_ID.eq(schoolId)).fetchAnyInto(SchoolIntro.class);
	}

	public List<SchoolIntro> findSchoolIntro(Collection<String> schoolIds) {
		return websiteCtx.selectFrom(SI).where(SI.SCHOOL_ID.in(schoolIds)).fetchInto(SchoolIntro.class);
	}
}
