/*
 * Decompiled with CFR 0.152.
 */
package com.jz.tool.token.configuration;

import com.google.common.collect.Lists;
import com.jz.common.utils.text.StringTools;
import com.jz.tool.token.annotation.WebTokenIgnore;
import com.jz.tool.token.proxy.TokenFilterCglibProxy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
public class TokenConfiguration {
    @Value(value="${server.context-path}")
    private String contextPath;
    @Autowired
    private WebApplicationContext applicationContext;

    @PostConstruct
    public void getIgnoreMapping() {
        if (StringTools.isEmptyAndBlank((String)this.contextPath)) {
            this.contextPath = "";
        } else if (!this.contextPath.startsWith("/")) {
            this.contextPath = "/" + this.contextPath;
        }
        if (this.contextPath.endsWith("/")) {
            this.contextPath = this.contextPath.substring(0, this.contextPath.length() - 1);
        }
        ArrayList whitelistUrl = Lists.newArrayList();
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)this.applicationContext.getBean(RequestMappingHandlerMapping.class);
        mapping.getHandlerMethods().forEach((mappingInfo, handlerMethod) -> {
            if (this.isContainsIgnore(handlerMethod.getMethod())) {
                mappingInfo.getPatternsCondition().getPatterns().forEach(url -> {
                    if (!url.startsWith("/")) {
                        url = "/" + url;
                    }
                    whitelistUrl.add(this.contextPath + url);
                });
            }
        });
        TokenFilterCglibProxy.setWhitelist(whitelistUrl);
    }

    private boolean isContainsIgnore(Method method) {
        if (method.isAnnotationPresent(WebTokenIgnore.class)) {
            return true;
        }
        return method.getDeclaringClass().isAnnotationPresent(WebTokenIgnore.class);
    }
}

