package com.jz.tool.token.proxy;

import java.lang.reflect.Method;
import java.util.List;

import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

/**
 * @Title TokenFilterCglibProxy
 * @Package com.jz.tool.token.proxy
 * @author tangjunfeng
 * @date 2018年12月11日 下午4:11:51
 * @version V1.0
 */
public class TokenFilterCglibProxy implements MethodInterceptor {

	private Class<?> clazz;
	private Object currentInstance;
	private static List<String> whitelistUrl;

	public static void setWhitelist(List<String> whitelist) {
		TokenFilterCglibProxy.whitelistUrl = whitelist;
	}

	public TokenFilterCglibProxy(Class<?> clazz) {
		this.clazz = clazz;
	}

	public Object getDynamicProxyInstance() {
		Enhancer enhancer = new Enhancer();
		enhancer.setSuperclass(this.clazz);
		enhancer.setCallback(this);
		// 通过字节码技术动态创建子类实例
		return currentInstance = enhancer.create();
	}

	@Override
	public Object intercept(Object instance, Method method, Object[] params, MethodProxy proxy) throws Throwable {
		if ("doFilter".equals(method.getName())) {
			HttpServletRequest request = (HttpServletRequest) params[0];
			if (whitelistUrl.contains(request.getRequestURI())) {
				HttpServletResponse response = (HttpServletResponse) params[1];
				FilterChain chain = (FilterChain) params[2];
				chain.doFilter(request, response);
				return null;
			}
		}
		return proxy.invokeSuper(currentInstance, params);
	}

}
