package com.jz.tool.token.configuration;

import java.lang.reflect.Method;
import java.util.List;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import com.google.common.collect.Lists;
import com.jz.common.utils.text.StringTools;
import com.jz.tool.token.annotation.WebTokenIgnore;
import com.jz.tool.token.proxy.TokenFilterCglibProxy;

@Configuration
public class TokenConfiguration {

	@Value("${server.context-path}")
	private String contextPath;

	@Autowired
	private WebApplicationContext applicationContext;

	@PostConstruct
	public void getIgnoreMapping() {
		if (StringTools.isEmptyAndBlank(contextPath)) {
			contextPath = "";
		} else if (!contextPath.startsWith("/")) {
			contextPath = "/" + contextPath;
		}
		if (contextPath.endsWith("/"))
			contextPath = contextPath.substring(0, contextPath.length() - 1);

		List<String> whitelistUrl = Lists.newArrayList();
		RequestMappingHandlerMapping mapping = applicationContext.getBean(RequestMappingHandlerMapping.class);
		mapping.getHandlerMethods().forEach((mappingInfo, handlerMethod) -> {
			if (isContainsIgnore(handlerMethod.getMethod())) {
				mappingInfo.getPatternsCondition().getPatterns().forEach(url -> {
					if (!url.startsWith("/"))
						url = "/" + url;
					whitelistUrl.add(contextPath + url);
				});
			}
		});
		TokenFilterCglibProxy.setWhitelist(whitelistUrl);
	}

	private boolean isContainsIgnore(Method method) {
		if (method.isAnnotationPresent(WebTokenIgnore.class))
			return true;
		return method.getDeclaringClass().isAnnotationPresent(WebTokenIgnore.class);
	}

}
