package com.jz.tool.token.configuration;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.io.ClassTools;
import com.jz.tool.token.annotation.WebTokenFilter;

public class DiscoveryTokenFilter {

	public static Class<?> discoveryMappingUrl(String... packages)
			throws IOException, ClassNotFoundException, URISyntaxException {
		List<URL> urls = ClassTools.findResourcesForPackage(packages);
		if (ArrayMapTools.isEmpty(urls))
			return null;
		for (URL url : getClassUrl(urls)) {
			Class<?> clazz = ClassTools.getClass(url);
			if (clazz.isAnnotationPresent(WebTokenFilter.class))
				return clazz;
		}
		return null;
	}

	private static List<URL> getClassUrl(List<URL> urls)
			throws ClassNotFoundException, IOException, URISyntaxException {
		List<URL> classUrls = Lists.newArrayList();
		for (URL url : urls) {
			if ("jar".equals(url.getProtocol()))
				classUrls.addAll(ClassTools.getClassUrlsForJar(url));
			else
				classUrls.addAll(ClassTools.getClassUrlsForFiles(url));
		}
		return classUrls;
	}

}