package com.jz.tool.token.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @Title WebTokenFilter
 * @Package com.jz.tool.token.annotation
 * @author tangjunfeng
 * @date 2018年12月12日 上午10:53:51
 * @version V1.0
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface WebTokenFilter {

	/** filter name */
	String value() default "";

	int order() default 1;

	String[] urlPatterns() default { "/*" };
}
