/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClusterConnectionHandler;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;

public class JedisSlotBasedConnectionHandler
extends JedisClusterConnectionHandler {
    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, int timeout) {
        this(nodes, poolConfig, timeout, timeout);
    }

    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout) {
        super(nodes, poolConfig, connectionTimeout, soTimeout);
    }

    @Override
    public Jedis getConnection() {
        List<JedisPool> pools = this.getShuffledNodesPool();
        for (JedisPool pool : pools) {
            Jedis jedis = null;
            try {
                jedis = pool.getResource();
                if (jedis == null) continue;
                String result = jedis.ping();
                if (result.equalsIgnoreCase("pong")) {
                    return jedis;
                }
                jedis.close();
            }
            catch (JedisException ex) {
                if (jedis == null) continue;
                jedis.close();
            }
        }
        throw new JedisConnectionException("no reachable node in cluster");
    }

    @Override
    public Jedis getConnectionFromSlot(int slot) {
        JedisPool connectionPool = this.cache.getSlotPool(slot);
        if (connectionPool != null) {
            return connectionPool.getResource();
        }
        return this.getConnection();
    }

    @Override
    protected List<JedisPool> getShuffledNodesPool() {
        ArrayList<JedisPool> pools = new ArrayList<JedisPool>();
        pools.addAll(this.cache.getNodes().values());
        Collections.shuffle(pools);
        return pools;
    }

    @Override
    public JedisPool getConnectionPoolFromSlot(int slot) {
        return this.cache.getSlotPool(slot);
    }
}

