/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClusterConnectionHandler;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.commands.RedisPipeline;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;
import redis.clients.util.JedisClusterCRC16;
import redis.clients.util.SafeEncoder;

public class ClusterPseudoPipeline
implements RedisPipeline,
Closeable {
    private JedisClusterConnectionHandler connHandler;
    private Map<JedisPool, Jedis> pool2connMap = new HashMap<JedisPool, Jedis>();
    private Map<Jedis, Pipeline> conn2pipeMap = new HashMap<Jedis, Pipeline>();

    private static int getSlot(String key) {
        return JedisClusterCRC16.getSlot(SafeEncoder.encode(key));
    }

    private static void debugLogHelper(String line) {
    }

    private static void errLogHelper(String line) {
        StackTraceElement[] stackElements = Thread.currentThread().getStackTrace();
        if (stackElements != null) {
            for (int i = 0; i < stackElements.length; ++i) {
                System.err.print(stackElements[i].getClassName() + "/t");
                System.err.print(stackElements[i].getFileName() + "/t");
                System.err.print(stackElements[i].getLineNumber() + "/t");
                System.err.println(stackElements[i].getMethodName());
            }
        }
        System.err.println("-----------------------------------");
        System.err.println(line);
    }

    public void setConnectionHandler(JedisClusterConnectionHandler connHandler) {
        this.connHandler = connHandler;
    }

    private Pipeline getOrReusePipeline(String key) {
        Pipeline res;
        JedisPool pool = this.connHandler.getConnectionPoolFromSlot(ClusterPseudoPipeline.getSlot(key));
        if (null == pool) {
            throw new JedisConnectionException("no pool for key" + key);
        }
        Jedis conn = this.pool2connMap.get(pool);
        if (null == conn) {
            conn = pool.getResource();
            if (null == conn) {
                throw new JedisConnectionException("get conn for cluster pipe failed");
            }
            ClusterPseudoPipeline.debugLogHelper("fetched for " + key);
            this.pool2connMap.put(pool, conn);
        }
        if ((res = this.conn2pipeMap.get(conn)) == null) {
            res = conn.pipelined();
            this.conn2pipeMap.put(conn, res);
        }
        return res;
    }

    public void sync() {
        for (Map.Entry<Jedis, Pipeline> entry : this.conn2pipeMap.entrySet()) {
            Pipeline pipe = entry.getValue();
            pipe.sync();
        }
    }

    private void closeConns() throws Exception {
        Exception exRes = null;
        for (Map.Entry<Jedis, Pipeline> entry : this.conn2pipeMap.entrySet()) {
            Jedis conn = entry.getKey();
            try {
                conn.close();
            }
            catch (Exception e) {
                exRes = e;
            }
        }
        if (null != exRes) {
            throw exRes;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.sync();
        }
        finally {
            try {
                this.closeConns();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public Response<Long> append(String key, String value) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.append(key, value);
    }

    @Override
    public Response<List<String>> blpop(String arg) {
        Pipeline p = this.getOrReusePipeline(arg);
        return p.blpop(arg);
    }

    @Override
    public Response<List<String>> brpop(String arg) {
        Pipeline p = this.getOrReusePipeline(arg);
        return p.brpop(arg);
    }

    @Override
    public Response<Long> decr(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.decr(key);
    }

    @Override
    public Response<Long> decrBy(String key, long integer) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.decrBy(key, integer);
    }

    @Override
    public Response<Long> del(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.del(key);
    }

    @Override
    public Response<String> echo(String string) {
        Pipeline p = this.getOrReusePipeline(string);
        return p.echo(string);
    }

    @Override
    public Response<Boolean> exists(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.exists(key);
    }

    @Override
    public Response<Long> expire(String key, int seconds) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.expire(key, seconds);
    }

    @Override
    public Response<Long> pexpire(String key, long milliseconds) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.pexpire(key, milliseconds);
    }

    @Override
    public Response<Long> expireAt(String key, long unixTime) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.expireAt(key, unixTime);
    }

    @Override
    public Response<Long> pexpireAt(String key, long millisecondsTimestamp) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.pexpireAt(key, millisecondsTimestamp);
    }

    @Override
    public Response<String> get(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.get(key);
    }

    @Override
    public Response<Boolean> getbit(String key, long offset) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.getbit(key, offset);
    }

    @Override
    public Response<String> getrange(String key, long startOffset, long endOffset) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.getrange(key, startOffset, endOffset);
    }

    @Override
    public Response<String> getSet(String key, String value) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.getSet(key, value);
    }

    @Override
    public Response<Long> hdel(String key, String ... field) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.hdel(key, field);
    }

    @Override
    public Response<Boolean> hexists(String key, String field) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.hexists(key, field);
    }

    @Override
    public Response<String> hget(String key, String field) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.hget(key, field);
    }

    @Override
    public Response<Map<String, String>> hgetAll(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.hgetAll(key);
    }

    @Override
    public Response<Long> hincrBy(String key, String field, long value) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.hincrBy(key, field, value);
    }

    @Override
    public Response<Set<String>> hkeys(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.hkeys(key);
    }

    @Override
    public Response<Long> hlen(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.hlen(key);
    }

    @Override
    public Response<List<String>> hmget(String key, String ... fields) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.hmget(key, fields);
    }

    @Override
    public Response<String> hmset(String key, Map<String, String> hash) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.hmset(key, hash);
    }

    @Override
    public Response<Long> hset(String key, String field, String value) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.hset(key, field, value);
    }

    @Override
    public Response<Long> hsetnx(String key, String field, String value) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.hsetnx(key, field, value);
    }

    @Override
    public Response<List<String>> hvals(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.hvals(key);
    }

    @Override
    public Response<Long> incr(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.incr(key);
    }

    @Override
    public Response<Long> incrBy(String key, long integer) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.incrBy(key, integer);
    }

    @Override
    public Response<String> lindex(String key, long index) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.lindex(key, index);
    }

    @Override
    public Response<Long> linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.linsert(key, where, pivot, value);
    }

    @Override
    public Response<Long> llen(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.llen(key);
    }

    @Override
    public Response<String> lpop(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.lpop(key);
    }

    @Override
    public Response<Long> lpush(String key, String ... string) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.lpush(key, string);
    }

    @Override
    public Response<Long> lpushx(String key, String ... string) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.lpushx(key, string);
    }

    @Override
    public Response<List<String>> lrange(String key, long start, long end) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.lrange(key, start, end);
    }

    @Override
    public Response<Long> lrem(String key, long count, String value) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.lrem(key, count, value);
    }

    @Override
    public Response<String> lset(String key, long index, String value) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.lset(key, index, value);
    }

    @Override
    public Response<String> ltrim(String key, long start, long end) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.ltrim(key, start, end);
    }

    @Override
    public Response<Long> move(String key, int dbIndex) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.move(key, dbIndex);
    }

    @Override
    public Response<Long> persist(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.persist(key);
    }

    @Override
    public Response<String> rpop(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.rpop(key);
    }

    @Override
    public Response<Long> rpush(String key, String ... string) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.rpush(key, string);
    }

    @Override
    public Response<Long> rpushx(String key, String ... string) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.rpushx(key, string);
    }

    @Override
    public Response<Long> sadd(String key, String ... member) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.sadd(key, member);
    }

    @Override
    public Response<Long> scard(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.scard(key);
    }

    @Override
    public Response<Boolean> sismember(String key, String member) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.sismember(key, member);
    }

    @Override
    public Response<String> set(String key, String value) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.set(key, value);
    }

    @Override
    public Response<Boolean> setbit(String key, long offset, boolean value) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.setbit(key, offset, value);
    }

    @Override
    public Response<String> setex(String key, int seconds, String value) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.setex(key, seconds, value);
    }

    @Override
    public Response<Long> setnx(String key, String value) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.setnx(key, value);
    }

    @Override
    public Response<Set<String>> smembers(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.smembers(key);
    }

    @Override
    public Response<List<String>> sort(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.sort(key);
    }

    @Override
    public Response<List<String>> sort(String key, SortingParams sortingParameters) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.sort(key, sortingParameters);
    }

    @Override
    public Response<String> spop(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.spop(key);
    }

    @Override
    public Response<Set<String>> spop(String key, long count) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.spop(key, count);
    }

    @Override
    public Response<String> srandmember(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.srandmember(key);
    }

    @Override
    public Response<Long> srem(String key, String ... member) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.srem(key, member);
    }

    @Override
    public Response<Long> strlen(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.strlen(key);
    }

    @Override
    public Response<String> substr(String key, int start, int end) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.substr(key, start, end);
    }

    @Override
    public Response<Long> ttl(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.ttl(key);
    }

    @Override
    public Response<String> type(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.type(key);
    }

    @Override
    public Response<Long> zadd(String key, double score, String member) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zadd(key, score, member);
    }

    @Override
    public Response<Long> zcard(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zcard(key);
    }

    @Override
    public Response<Long> zcount(String key, double min, double max) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zcount(key, min, max);
    }

    @Override
    public Response<Double> zincrby(String key, double score, String member) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zincrby(key, score, member);
    }

    @Override
    public Response<Set<String>> zrange(String key, long start, long end) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrange(key, start, end);
    }

    @Override
    public Response<Set<String>> zrangeByScore(String key, double min, double max) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrangeByScore(key, min, max);
    }

    @Override
    public Response<Set<String>> zrangeByScore(String key, String min, String max) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrangeByScore(key, min, max);
    }

    @Override
    public Response<Set<String>> zrangeByScore(String key, double min, double max, int offset, int count) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, double min, double max) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Response<Set<String>> zrevrangeByScore(String key, double max, double min) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrevrangeByScore(key, max, min);
    }

    @Override
    public Response<Set<String>> zrevrangeByScore(String key, String max, String min) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrevrangeByScore(key, max, min);
    }

    @Override
    public Response<Set<String>> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrevrangeByScore(key, max, min, offset, count);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, double max, double min) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrevrangeByScoreWithScores(key, max, min);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    @Override
    public Response<Set<Tuple>> zrangeWithScores(String key, long start, long end) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrangeWithScores(key, start, end);
    }

    @Override
    public Response<Long> zrank(String key, String member) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrank(key, member);
    }

    @Override
    public Response<Long> zrem(String key, String ... member) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrem(key, member);
    }

    @Override
    public Response<Long> zremrangeByRank(String key, long start, long end) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zremrangeByRank(key, start, end);
    }

    @Override
    public Response<Long> zremrangeByScore(String key, double start, double end) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zremrangeByScore(key, start, end);
    }

    @Override
    public Response<Set<String>> zrevrange(String key, long start, long end) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrevrange(key, start, end);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeWithScores(String key, long start, long end) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrevrangeWithScores(key, start, end);
    }

    @Override
    public Response<Long> zrevrank(String key, String member) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrevrank(key, member);
    }

    @Override
    public Response<Double> zscore(String key, String member) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zscore(key, member);
    }

    @Override
    public Response<Long> zlexcount(String key, String min, String max) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zlexcount(key, min, max);
    }

    @Override
    public Response<Set<String>> zrangeByLex(String key, String min, String max) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrangeByLex(key, min, max);
    }

    @Override
    public Response<Set<String>> zrangeByLex(String key, String min, String max, int offset, int count) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrangeByLex(key, min, max, offset, count);
    }

    @Override
    public Response<Set<String>> zrevrangeByLex(String key, String max, String min) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrevrangeByLex(key, max, min);
    }

    @Override
    public Response<Set<String>> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zrevrangeByLex(key, max, min, offset, count);
    }

    @Override
    public Response<Long> zremrangeByLex(String key, String start, String end) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zremrangeByLex(key, start, end);
    }

    @Override
    public Response<Long> bitcount(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.bitcount(key);
    }

    @Override
    public Response<Long> bitcount(String key, long start, long end) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.bitcount(key, start, end);
    }

    @Override
    public Response<Long> pfadd(String key, String ... elements) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.pfadd(key, elements);
    }

    @Override
    public Response<Long> pfcount(String key) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.pfcount(key);
    }

    @Override
    public Response<Long> setrange(String key, long offset, String value) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.setrange(key, offset, value);
    }

    @Override
    public Response<Long> zadd(String key, double score, String member, ZAddParams params) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zadd(key, score, member, params);
    }

    @Override
    public Response<Long> zadd(String key, Map<String, Double> scoreMembers) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zadd(key, scoreMembers);
    }

    @Override
    public Response<Long> zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zadd(key, scoreMembers, params);
    }

    @Override
    public Response<Double> zincrby(String key, double score, String member, ZIncrByParams params) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.zincrby(key, score, member, params);
    }

    @Override
    public Response<Long> geoadd(String key, double longitude, double latitude, String member) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.geoadd(key, longitude, latitude, member);
    }

    @Override
    public Response<Long> geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.geoadd(key, memberCoordinateMap);
    }

    @Override
    public Response<Double> geodist(String key, String member1, String member2) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.geodist(key, member1, member2);
    }

    @Override
    public Response<Double> geodist(String key, String member1, String member2, GeoUnit unit) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.geodist(key, member1, member2, unit);
    }

    @Override
    public Response<List<String>> geohash(String key, String ... members) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.geohash(key, members);
    }

    @Override
    public Response<List<GeoCoordinate>> geopos(String key, String ... members) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.geopos(key, members);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.georadius(key, longitude, latitude, radius, unit);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.georadius(key, longitude, latitude, radius, unit, param);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.georadiusByMember(key, member, radius, unit);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        Pipeline p = this.getOrReusePipeline(key);
        return p.georadiusByMember(key, member, radius, unit, param);
    }
}

