package com.jz.jar.oa.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.jooq.Record1;
import org.jooq.SelectConditionStep;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.oa.enmus.UserWorkflow;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.records.UserWorkflowListRecord;

@Lazy
@Repository
public class UserWorkflowListRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.UserWorkflowList UWFL = Tables.USER_WORKFLOW_LIST;

	private UserWorkflowListRecord makeRecord(String identify, String uid, UserWorkflow type, long timeMillis) {
		UserWorkflowListRecord record = new UserWorkflowListRecord();
		record.setUid(uid);
		record.setUwfid(identify);
		record.setType(type.getCode());
		record.setLastUpdate(timeMillis);
		return record;
	}

	public void addUserWorkflowList(String identify, String launch, String pendingHandler,
			Collection<String> carbonCopies) {
		long timeMillis = System.currentTimeMillis();
		List<UserWorkflowListRecord> listRecords = Lists.newArrayList();
		// 发起人
		if (StringTools.isNotEmptyAndBlank(launch))
			listRecords.add(makeRecord(identify, launch, UserWorkflow.LIST_LAUNCH, timeMillis));
		// 待处理
		if (StringTools.isNotEmptyAndBlank(pendingHandler))
			listRecords.add(makeRecord(identify, pendingHandler, UserWorkflow.LIST_PENDING, timeMillis));
		for (String carbonCopy : carbonCopies) { // carbonCopy
			listRecords.add(makeRecord(identify, carbonCopy, UserWorkflow.LIST_CARBON_COPY, timeMillis));
		}
		oaCtx.batchInsert(listRecords).execute();
	}

	public List<String> getUserWorkflows(String uid, int code) {
		SelectConditionStep<Record1<String>> step = oaCtx.select(UWFL.UWFID).from(UWFL)
				.where(UWFL.UID.eq(uid).and(UWFL.TYPE.eq(code)));
		if (code == 4 && !StringUtils.equals(uid, "oa_admin")) {
			step.orderBy(UWFL.LAST_UPDATE.desc()).limit(1000);
		}
		if (code == 3) {
			step.orderBy(UWFL.LAST_UPDATE.desc()).limit(2000);
		}
		return step.fetchInto(String.class);
	}

	public void addPendingList(String identify, String handler) {
		long timeMillis = System.currentTimeMillis();
		oaCtx.insertInto(UWFL).set(makeRecord(identify, handler, UserWorkflow.LIST_PENDING, timeMillis))
				.onDuplicateKeyUpdate().set(UWFL.TYPE, UserWorkflow.LIST_PENDING.getCode())
				.set(UWFL.LAST_UPDATE, timeMillis).execute();
	}

	public void changePendingList(Collection<String> uwfids, String taker) {
		long timeMillis = System.currentTimeMillis();
		oaCtx.update(UWFL).set(UWFL.UID, taker).set(UWFL.LAST_UPDATE, timeMillis)
				.where(UWFL.UWFID.in(uwfids).and(UWFL.TYPE.eq(UserWorkflow.LIST_PENDING.getCode()))).execute();
	}

	public void updateType(String uid, String identify, UserWorkflow type) {
		UserWorkflowListRecord record = new UserWorkflowListRecord();
		record.setType(type.getCode());
		record.setLastUpdate(System.currentTimeMillis());
		oaCtx.update(UWFL).set(record).where(UWFL.UID.eq(uid).and(UWFL.UWFID.eq(identify))).execute();
	}

	public List<String> getContainsList(String identify, Collection<String> uids) {
		return oaCtx.select(UWFL.UID).from(UWFL).where(UWFL.UID.in(uids).and(UWFL.UWFID.eq(identify)))
				.fetchInto(String.class);
	}

	public void addCarbonCopyList(String identify, Collection<String> ccs) {
		long timeMillis = System.currentTimeMillis();
		List<UserWorkflowListRecord> listRecords = Lists.newArrayList();
		for (String carbonCopy : ccs) { // carbonCopy
			listRecords.add(makeRecord(identify, carbonCopy, UserWorkflow.LIST_CARBON_COPY, timeMillis));
		}
		oaCtx.batchInsert(listRecords).execute();
	}

	public boolean isContains(String uid, String identify) {
		return oaCtx.fetchExists(UWFL, UWFL.UID.eq(uid).and(UWFL.UWFID.eq(identify)));
	}

	public void cleanPendingList(String identify) {
		oaCtx.deleteFrom(UWFL).where(UWFL.UWFID.eq(identify).and(UWFL.TYPE.eq(UserWorkflow.LIST_PENDING.getCode())))
				.execute();
	}

	public void deletePendingInfo(String id, String uid) {
		oaCtx.deleteFrom(UWFL)
				.where(UWFL.UWFID.eq(id).and(UWFL.TYPE.eq(UserWorkflow.LIST_PENDING.getCode())).and(UWFL.UID.eq(uid)))
				.execute();
	}

	public void cleanList(String identify) {
		oaCtx.deleteFrom(UWFL).where(UWFL.UWFID.eq(identify)).execute();
	}

	public List<String> getHandledByMe(String uid, UserWorkflow code, Collection<String> allUwfids) {
		return oaCtx.select(UWFL.UWFID).from(UWFL)
				.where(UWFL.UID.eq(uid).and(UWFL.TYPE.eq(code.getCode())).and(UWFL.UWFID.in(allUwfids)))
				.fetchInto(String.class);
	}

	public List<String> mutiGetContainsList(Collection<String> uwfids, String taker) {
		return oaCtx.select(UWFL.UWFID).from(UWFL).where(UWFL.UID.eq(taker).and(UWFL.UWFID.in(uwfids)))
				.fetchInto(String.class);
	}

	public List<String> getPendingUidUwfids(String uid) {
		return oaCtx.select(UWFL.UWFID).from(UWFL)
				.where(UWFL.UID.eq(uid).and(UWFL.TYPE.eq(UserWorkflow.LIST_PENDING.getCode()))).fetchInto(String.class);
	}

	public void changeType(Collection<String> needChangeTypeUwfids, String taker) {
		oaCtx.deleteFrom(UWFL)
				.where(UWFL.UWFID.in(needChangeTypeUwfids).and(UWFL.TYPE.eq(UserWorkflow.LIST_PENDING.getCode())))
				.execute();
		oaCtx.update(UWFL).set(UWFL.TYPE, UserWorkflow.LIST_PENDING.getCode())
				.where(UWFL.UWFID.in(needChangeTypeUwfids).and(UWFL.UID.eq(taker))).execute();
	}

	public Map<String, Long> mutiGetAuditTimes(String uid, List<String> uwfids, int type) {
		return oaCtx.select(UWFL.UWFID, UWFL.LAST_UPDATE).from(UWFL)
				.where(UWFL.UID.eq(uid).and(UWFL.UWFID.in(uwfids)).and(UWFL.TYPE.eq(type)))
				.fetchMap(UWFL.UWFID, UWFL.LAST_UPDATE);
	}

}
