/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.repository;

import com.jz.jar.oa.repository.OABaseRepository;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.UserTraining;
import com.jz.jooq.oa.tables.records.UserTrainingRecord;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Record;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserTrainingRepository
extends OABaseRepository {
    private static final UserTraining T = Tables.USER_TRAINING;

    public void updateUserTraining(String fuid, List<UserTrainingRecord> trainingRecords) {
        this.oaCtx.deleteFrom((Table)T).where(new Condition[]{UserTrainingRepository.T.UID.eq((Object)fuid)}).execute();
        this.oaCtx.batchInsert(trainingRecords).execute();
    }

    public List<com.jz.jooq.oa.tables.pojos.UserTraining> getUserTrainings(String fuid) {
        return this.oaCtx.selectFrom((Table)T).where(new Condition[]{UserTrainingRepository.T.UID.eq((Object)fuid)}).orderBy(UserTrainingRepository.T.IDX.desc()).fetchInto(com.jz.jooq.oa.tables.pojos.UserTraining.class);
    }

    public void createUserTraining(String fuid, int idx, String name, String type, Long startTime, Long endTime, int status, String remark, String certificate) {
        UserTrainingRecord record = new UserTrainingRecord();
        record.setUid(fuid);
        record.setIdx(Integer.valueOf(idx));
        record.setName(name);
        record.setType(type);
        record.setStartTime(startTime);
        record.setEndTime(endTime);
        record.setStatus(Integer.valueOf(status));
        record.setRemark(remark);
        record.setCertificate(certificate);
        record.setLastUpdated(Long.valueOf(System.currentTimeMillis()));
        this.oaCtx.insertInto((Table)T).set((Record)record).execute();
    }

    public List<com.jz.jooq.oa.tables.pojos.UserTraining> mutiGetUserTrainings(Collection<String> uids) {
        return this.oaCtx.selectFrom((Table)T).where(new Condition[]{UserTrainingRepository.T.UID.in(uids)}).orderBy(UserTrainingRepository.T.UID.asc(), UserTrainingRepository.T.IDX.desc()).fetchInto(com.jz.jooq.oa.tables.pojos.UserTraining.class);
    }
}

