/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.repository;

import com.jz.jar.oa.repository.OABaseRepository;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.Position;
import com.jz.jooq.oa.tables.records.PositionRecord;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class OAPositionRepository
extends OABaseRepository {
    private static final com.jz.jooq.oa.tables.Position P = Tables.POSITION;

    public List<Position> getAllPosition() {
        return this.oaCtx.selectFrom((Table)P).where(new Condition[]{OAPositionRepository.P.ENABLE.eq((Object)1)}).fetchInto(Position.class);
    }

    public List<Position> mutiGetPositions(Collection<String> positionIds) {
        return this.oaCtx.selectFrom((Table)P).where(new Condition[]{OAPositionRepository.P.ID.in(positionIds)}).fetchInto(Position.class);
    }

    public Position getPosition(String positionId) {
        return (Position)this.oaCtx.selectFrom((Table)P).where(new Condition[]{OAPositionRepository.P.ID.eq((Object)positionId)}).fetchAnyInto(Position.class);
    }

    public List<Position> listAllPosition(String name, int start, int size) {
        Condition condition = OAPositionRepository.P.ENABLE.eq((Object)1);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            condition = condition.and(OAPositionRepository.P.NAME.like("%" + name + "%"));
        }
        return this.oaCtx.selectFrom((Table)P).where(new Condition[]{condition}).orderBy(OAPositionRepository.P.CREATE_TIME.desc()).limit(start, size).fetchInto(Position.class);
    }

    public boolean checkPositionExist(String name, String deptId) {
        return this.oaCtx.fetchExists((Table)P, OAPositionRepository.P.NAME.eq((Object)name).and(OAPositionRepository.P.DEPT_ID.eq((Object)deptId)));
    }

    public void createPosition(String id, String deptId, String name) {
        this.oaCtx.insertInto((Table)P).set((Record)new PositionRecord(id, deptId, name, null, Long.valueOf(System.currentTimeMillis()), Integer.valueOf(1))).execute();
    }

    public void updatePosition(String id, String deptId, String name) {
        PositionRecord record = new PositionRecord();
        record.setDeptId(deptId);
        record.setName(name);
        this.oaCtx.update((Table)P).set((Record)record).where(new Condition[]{OAPositionRepository.P.ID.eq((Object)id)}).execute();
    }

    public void deletePosition(String id) {
        this.oaCtx.update((Table)P).set((Field)OAPositionRepository.P.ENABLE, (Object)0).where(new Condition[]{OAPositionRepository.P.ID.eq((Object)id)}).execute();
    }

    public boolean checkName(String name, String deptId) {
        return this.oaCtx.fetchExists((Table)P, OAPositionRepository.P.NAME.eq((Object)name).and(OAPositionRepository.P.DEPT_ID.eq((Object)deptId)));
    }

    public void deletePositionDeptId(String deptId) {
        this.oaCtx.update((Table)P).set((Field)OAPositionRepository.P.ENABLE, (Object)0).where(new Condition[]{OAPositionRepository.P.DEPT_ID.eq((Object)deptId)}).execute();
    }

    public int cntPositions(String name) {
        return this.oaCtx.fetchCount((Table)P, StringUtils.isEmpty((CharSequence)name) ? DSL.trueCondition() : OAPositionRepository.P.NAME.like("%" + name + "%"));
    }
}

