package com.jz.jar.oa.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.oa.repository.OAUserRepository;
import com.jz.jar.oa.repository.UserPositionHistoryRepository;
import com.jz.jar.oa.repository.UserRewardsAndPunishmentRepository;
import com.jz.jar.oa.repository.UserSkillRepository;
import com.jz.jar.oa.repository.UserTrainingRepository;
import com.jz.jar.oa.repository.UserWelfareRepository;
import com.jz.jooq.oa.tables.pojos.User;
import com.jz.jooq.oa.tables.pojos.UserPositionHistory;
import com.jz.jooq.oa.tables.pojos.UserRewardsAndPunishment;
import com.jz.jooq.oa.tables.pojos.UserSkill;
import com.jz.jooq.oa.tables.pojos.UserTraining;
import com.jz.jooq.oa.tables.pojos.UserWelfare;
import com.jz.jooq.oa.tables.pojos.WorkAddress;
import com.jz.jooq.oa.tables.records.UserPositionHistoryRecord;
import com.jz.jooq.oa.tables.records.UserRecord;
import com.jz.jooq.oa.tables.records.UserRewardsAndPunishmentRecord;
import com.jz.jooq.oa.tables.records.UserSkillRecord;
import com.jz.jooq.oa.tables.records.UserTrainingRecord;
import com.jz.jooq.oa.tables.records.UserWelfareRecord;

@Lazy
@Service
public class OAUserService {

	@Autowired
	private OAUserRepository userRepository;
	@Autowired
	private UserSkillRepository userSkillRepository;
	@Autowired
	private UserWelfareRepository userWelfareRepository;
	@Autowired
	private UserTrainingRepository userTrainingRepository;
	@Autowired
	private UserRewardsAndPunishmentRepository userRewardsAndPunishmentRepository;
	@Autowired
	private UserPositionHistoryRepository userPositionHistoryRepository;
	@Autowired
	private OAWorkAddressService workAddressService;

	public void insUpdateUser(String uid, String chineseName, String englishName, String phone, String companyId,
			String workAddrId, String deptId, String positionId, String superiorId, String joinDate, String relations,
			Integer insurance, Integer childFree, Integer trainAgreement, Integer annualLeaveDays, String certificate,
			int status) {
		userRepository.insUpdateUser(uid, chineseName, englishName, phone, companyId, workAddrId, deptId, positionId,
				superiorId, joinDate, relations, insurance, childFree, trainAgreement, annualLeaveDays, certificate,
				status);
	}

	public void updateUserStatus(String uid, int status) {
		Preconditions.checkArgument(status == 1 || status == 2, "status参数错误");
		userRepository.updateUserStatus(uid, status);
	}

	public User getUser(String uid) {
		return userRepository.getUser(uid);
	}

	public User getUserInfo(String uid) {
		return userRepository.getUserInfo(uid);
	}

	public Map<String, User> mutiGetUserMap(Collection<String> uids) {
		List<User> list = userRepository.mutGetUsers(uids);
		if (ArrayMapTools.isEmpty(list))
			return Maps.newHashMap();
		return list.stream().collect(Collectors.toMap(it -> it.getUid(), it -> it));
	}

	public Map<String, User> mutGetAllUsers(Collection<String> uids) {
		List<User> list = userRepository.mutGetAllUsers(uids);
		if (ArrayMapTools.isEmpty(list))
			return Maps.newHashMap();
		return list.stream().collect(Collectors.toMap(it -> it.getUid(), it -> it));
	}

	public Map<String, User> multiGetSimpleUser(Collection<String> uids) {
		List<User> users = userRepository.multiGetSimpleUser(uids);
		if (ArrayMapTools.isEmpty(users))
			return Maps.newHashMap();
		return users.stream().collect(Collectors.toMap(it -> it.getUid(), it -> it));
	}

	public Map<String, User> multiGetAllSimpleUser(Collection<String> uids) {
		List<User> users = userRepository.multiGetAllSimpleUser(uids);
		if (ArrayMapTools.isEmpty(users))
			return Maps.newHashMap();
		return users.stream().collect(Collectors.toMap(it -> it.getUid(), it -> it));
	}

	public User getSimpleUser(String uid) {
		return userRepository.getSimpleUser(uid);
	}

	public User getAllSimpleUser(String uid) {
		return userRepository.getAllSimpleUser(uid);
	}

	public Map<String, Integer> getStaffNumByCompanyIds(Set<String> companyIds) {
		return userRepository.getStaffNumByCompanyIds(companyIds);
	}

	public boolean isIncumbency(String uid) {
		return userRepository.isIncumbency(uid);
	}

	public int cntCompanyUser(String id) {
		return userRepository.cntCompanyUser(id);
	}

	public int cntDeptUser(String deptId) {
		return userRepository.cntDeptUser(deptId);
	}

	public int cntPositionUser(String id) {
		return userRepository.cntPositionUser(id);
	}

	public Map<String, Integer> getStaffNumByWorkAddressIds(Set<String> workAddressIds) {
		return userRepository.getStaffNumByWorkAddressIds(workAddressIds);
	}

	public int cntWorkAddressUser(String id) {
		return userRepository.cntWorkAddressUser(id);
	}

	public int cntAllWorkAddressUser(String workAddrId) {
		return userRepository.cntAllWorkAddressUser(workAddrId);
	}

	public Map<String, Integer> getStaffNumByDeptIds(Set<String> deptIds) {
		return userRepository.getStaffNumByDeptIds(deptIds);
	}

	public List<User> getUserInfoPage(String companyId, String keyword, int start, int size) {
		return userRepository.getUserInfoPage(companyId, keyword, start, size);
	}

	public User getUserByPosition(String positionId) {
		return userRepository.getUserByPosition(positionId);
	}

	/** 当前公司下存在在职员工的所有部门Id */
	public List<String> getDeptIdsForCompany(String companyId) {
		return userRepository.getDeptIdsForCompany(companyId);
	}

	/** 当前部门下所有的在职员工 */
	public List<User> getUsersForDepartment(String companyId, String deptId) {
		return userRepository.getUsersForDepartment(companyId, deptId);
	}

	public User getUserByPhone(String phone) {
		return userRepository.getUserByPhone(phone);
	}

	public String getSuperiorUid(String uid) {
		return userRepository.getSuperiorUid(uid);
	}

	public void updateSuperior(String currentlySuperior, String newSuperior) {
		userRepository.updateSuperior(currentlySuperior, newSuperior);
	}

	public List<User> getUsersForWorkAddress(String workAddrId, int start, int size) {
		return userRepository.getUsersForWorkAddress(workAddrId, start, size);
	}

	public List<String> filterUidsByConditionsLimit(String uid, String departmentId, String companyId,
			String workAddrId, String keyword, Collection<String> filterWorkAddrIds,
			Collection<String> filterCompanyIds, int start, int size) {
		return userRepository.filterUidsByConditionsLimit(uid, departmentId, companyId, workAddrId, keyword,
				filterWorkAddrIds, filterCompanyIds, start, size);
	}

	public int cntUsersByConditions(String uid, String departmentId, String companyId, String workAddrId,
			String keyword, Collection<String> filterWorkAddrIds, Collection<String> filterCompanyIds) {
		return userRepository.cntUsersByConditions(uid, departmentId, companyId, workAddrId, keyword, filterWorkAddrIds,
				filterCompanyIds);
	}

	public int cntUsers(String uid, int status, String departmentId, String companyId, String workAddrId,
			String keyword) {
		return userRepository.cntUsers(uid, status, departmentId, companyId, workAddrId, keyword);
	}

	public List<User> filterUsersByConditionsLimit(String uid, int status, String departmentId, String companyId,
			String workAddrId, String keyword, int start, int size) {
		return userRepository.filterUsersByConditionsLimit(uid, status, departmentId, companyId, workAddrId, keyword,
				start, size);
	}

	public List<User> getHrList(List<String> hrs) {
		return userRepository.getHrList(hrs);
	}

	public List<String> findUserIdForWorkAddress(Collection<String> workAddressIds) {
		return userRepository.findUserIdForWorkAddress(workAddressIds);
	}

	public List<String> getCompanyForUser(Collection<String> uids) {
		return userRepository.getCompanyForUser(uids);
	}

	public void changeToResignation(String uid, int status, String resignationDate) {
		userRepository.changeToResignation(uid, status, resignationDate);
	}

	public List<String> filterUids(String keyword) {
		return userRepository.filterUids(keyword);
	}

	public List<String> getUsersByPosition(String positionId) {
		return userRepository.getUsersByPosition(positionId);
	}

	public void createUser(UserRecord record) {
		userRepository.createUser(record);
	}

	public void updateUser(String fuid, String chineseName, String englishName, String phone, int status,
			String cardType, String cardBak, String nationality, String country, String fertility, String residenceType,
			String residenceAddress, String contactAddress, String landline, String emergencyContact,
			String emergencyPhone, Integer insurance, Integer childFree, Integer trainAgreement, String joinDate) {
		userRepository.updateUser(fuid, chineseName, englishName, phone, status, cardType, cardBak, nationality,
				country, fertility, residenceType, residenceAddress, contactAddress, landline, emergencyContact,
				emergencyPhone, insurance, childFree, trainAgreement, joinDate);
	}

	public void updateUserPositionInfo(String fuid, String joinChannel, String referrer, String officialJoinDate,
			String contractStart, String contractEnd, String contractType, String contractNature, String deptId,
			String positionId, String superiorId, String relations, String workAddrId, String companyId,
			String laborUnion, String costCenter) {
		userRepository.updateUserPositionInfo(fuid, joinChannel, referrer, officialJoinDate, contractStart, contractEnd,
				contractType, contractNature, deptId, positionId, superiorId, relations, workAddrId, companyId,
				laborUnion, costCenter);
	}

	public void updateUserSkills(String fuid, List<UserSkillRecord> skillRecords) {
		userSkillRepository.updateUserSkills(fuid, skillRecords);
	}

	public void updateBackgroundSurvey(String fuid, String backgroundSurvey) {
		userRepository.updateBackgroundSurvey(fuid, backgroundSurvey);
	}

	public void updateUserAccountInfo(String fuid, String bankAccount, String bank, String bankArea, String fund,
			String socialSecurityType, String socialSecurityArea, String tax, Integer annualLeaveDays,
			String certificate, Integer oldLeaveDays, String leaveAdjustDate) {
		userRepository.updateUserAccountInfo(fuid, bankAccount, bank, bankArea, fund, socialSecurityType,
				socialSecurityArea, tax, annualLeaveDays, certificate, oldLeaveDays, leaveAdjustDate);
	}

	public void updateUserWelfare(String fuid, List<UserWelfareRecord> welfareRecords) {
		userWelfareRepository.updateUserWelfare(fuid, welfareRecords);
	}

	public void updateUserTraining(String fuid, List<UserTrainingRecord> trainingRecords) {
		userTrainingRepository.updateUserTraining(fuid, trainingRecords);
	}

	public void updateUserRewardsAndPunishment(String fuid, List<UserRewardsAndPunishmentRecord> rpRecords) {
		userRewardsAndPunishmentRepository.updateUserRewardsAndPunishment(fuid, rpRecords);
	}

	public void updateUserPositionHistory(String fuid, List<UserPositionHistoryRecord> positionRecords) {
		userPositionHistoryRepository.updateUserPositionHistory(fuid, positionRecords);
	}

	public List<UserSkill> getUserSkills(String fuid) {
		return userSkillRepository.getUserSkills(fuid);
	}

	public List<UserWelfare> getUserWelfares(String fuid) {
		return userWelfareRepository.getUserWelfares(fuid);
	}

	public List<UserTraining> getUserTrainings(String fuid) {
		return userTrainingRepository.getUserTrainings(fuid);
	}

	public List<UserRewardsAndPunishment> getUserRewardsAndPunishments(String fuid) {
		return userRewardsAndPunishmentRepository.getUserRewardsAndPunishments(fuid);
	}

	public List<UserPositionHistory> getUserPositionHistorys(String fuid) {
		return userPositionHistoryRepository.getUserPositionHistorys(fuid);
	}

	public void backInOffice(String fuid, String joinDate, String officialJoinDate, String contractStart,
			String contractEnd, String contractType, String contractNature) {
		userRepository.backInOffice(fuid, joinDate, officialJoinDate, contractStart, contractEnd, contractType,
				contractNature);
	}

	public void createUserTraining(String fuid, String name, String type, Long startTime, Long endTime, int status,
			String remark, String certificate) {
		List<UserTraining> userTrainings = userTrainingRepository.getUserTrainings(fuid);
		userTrainingRepository.createUserTraining(fuid, userTrainings.size() + 1, name, type, startTime, endTime,
				status, remark, certificate);
	}

	public Map<String, List<String>> multiGetWorkAddrUids(Collection<String> uids) {
		Map<String, List<String>> map = Maps.newHashMap();
		List<User> list = userRepository.multiGetUserAddr(uids);
		if (ArrayMapTools.isEmpty(list))
			return Maps.newHashMap();
		for (User u : list) {
			if (map.containsKey(u.getWorkAddrId())) {
				map.get(u.getWorkAddrId()).add(u.getUid());
			} else {
				map.put(u.getWorkAddrId(), Lists.newArrayList(u.getUid()));
			}
		}
		return map;
	}

	/** 获取用户所有下级 */
	public List<String> getSubordinates(String uid) {
		int n = 10;
		List<String> subordinateIds = userRepository.filterSubordinates(Sets.newHashSet(uid));
		if (ArrayMapTools.isEmpty(subordinateIds) || subordinateIds.contains(uid)) {
			return subordinateIds;
		}
		return getSubordinates(subordinateIds, n);
	}

	private List<String> getSubordinates(List<String> resultSubordinates, int n) {
		if (n < 0) {
			return resultSubordinates;
		}
		resultSubordinates.addAll(userRepository.filterSubordinates(resultSubordinates));
		--n;
		return getSubordinates(resultSubordinates, n);
	}

	public String getUserWorkAddress(String uid) {
		return userRepository.getUserWorkAddress(uid);
	}

	public Map<String, WorkAddress> multiGetWorkAddrs(Collection<String> uids) {
		List<User> list = userRepository.multiGetUserAddr(uids);
		Set<String> workAddrIds = Sets.newHashSet();
		Map<String, String> uid2WorkAddrId = Maps.newHashMap();
		list.forEach(it -> {
			workAddrIds.add(it.getWorkAddrId());
			uid2WorkAddrId.put(it.getUid(), it.getWorkAddrId());
		});
		Map<String, WorkAddress> wMap = workAddressService.mutiGetWorkAddressMap(workAddrIds);
		Map<String, WorkAddress> rsMap = Maps.newHashMap();
		uid2WorkAddrId.forEach((uid, workAddrId) -> {
			if (wMap.containsKey(workAddrId)) {
				rsMap.put(uid, wMap.get(workAddrId));
			}
		});
		return rsMap;
	}

	public Integer getOldLeaveDays(String fuid) {
		return userRepository.getOldLeaveDays(fuid);
	}

}
