package com.jz.jar.oa.repository;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.WorkAddress;
import com.jz.jooq.oa.tables.records.WorkAddressRecord;

@Lazy
@Repository
public class OAWorkAddressRepository extends OABaseRepository {
	private static final com.jz.jooq.oa.tables.WorkAddress WD = Tables.WORK_ADDRESS;

	public List<WorkAddress> getAllWorkAddress() {
		return oaCtx.selectFrom(WD).where(WD.ENABLE.eq(1)).fetchInto(WorkAddress.class);
	}

	public List<WorkAddress> mutiWorkAddress(Collection<String> workAddrIds) {
		return oaCtx.selectFrom(WD).where(WD.ID.in(workAddrIds)).fetchInto(WorkAddress.class);
	}

	public WorkAddress getWorkAddress(String workAddrId) {
		return oaCtx.selectFrom(WD).where(WD.ID.eq(workAddrId)).fetchAnyInto(WorkAddress.class);
	}

	public boolean checkName(String name) {
		return oaCtx.fetchExists(WD, WD.NAME.eq(name));
	}

	public void createWorkAddress(String id, String name, String address, String timekeeper, String workday,
			Integer flexible, Double floatHour, String checkin, String checkout) {
		oaCtx.insertInto(WD)
				.set(new WorkAddressRecord(id, name, address, timekeeper, workday, checkin, checkout, flexible,
						floatHour != null ? new BigDecimal(floatHour) : BigDecimal.ZERO, System.currentTimeMillis(), 1))
				.execute();
	}

	public void updateWorkAddress(String id, String name, String address, String timekeeper, String workday,
			Integer flexible, Double floatHour, String checkin, String checkout) {
		WorkAddressRecord record = new WorkAddressRecord();
		record.setName(name);
		record.setAddress(address);
		record.setTimekeeper(timekeeper);
		record.setWorkday(workday);
		record.setCheckin(checkin);
		record.setCheckout(checkout);
		record.setFlexible(flexible);
		if (floatHour != null)
			record.setFloatHour(new BigDecimal(floatHour));
		oaCtx.update(WD).set(record).where(WD.ID.eq(id)).execute();
	}

	public void deleteWorkAddress(String id) {
		oaCtx.update(WD).set(WD.ENABLE, 0).where(WD.ID.eq(id)).execute();
	}

	public void updateTimekeeper(String currentlyKeeper, String newKeeper) {
		oaCtx.update(WD).set(WD.TIMEKEEPER, newKeeper).where(WD.TIMEKEEPER.eq(currentlyKeeper)).execute();
	}

	public boolean isTimekeeper(String uid, String workAddrId) {
		return oaCtx.fetchExists(WD, WD.ID.eq(workAddrId).and(WD.TIMEKEEPER.eq(uid)));
	}

	public List<String> findWorkAddressIdForKeeper(String uid) {
		return oaCtx.select(WD.ID).from(WD).where(WD.TIMEKEEPER.eq(uid).and(WD.ENABLE.eq(1))).fetchInto(String.class);
	}

	public List<WorkAddress> getAllWorkAddressSimple() {
		return oaCtx.select(WD.ID, WD.NAME).from(WD).where(WD.ENABLE.eq(1)).fetchInto(WorkAddress.class);
	}

	public List<String> getAllAddressIds() {
		return oaCtx.select(WD.ID).from(WD).where(WD.ENABLE.eq(1)).fetchInto(String.class);
	}

	public List<WorkAddress> getFilteredWorkAddress(String name) {
		Condition condition = WD.ENABLE.eq(1);
		if (StringUtils.isNotEmpty(name)) {
			condition = condition.and(WD.NAME.like("%" + name + "%"));
		}
		return oaCtx.selectFrom(WD).where(condition).fetchInto(WorkAddress.class);
	}
}
