package com.jz.jar.oa.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.WorkflowSettingDynamicNode;

@Lazy
@Repository
public class WorkflowSettingDynamicNodeRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.WorkflowSettingDynamicNode DYNAMIC = Tables.WORKFLOW_SETTING_DYNAMIC_NODE;

	public List<WorkflowSettingDynamicNode> getWorkflowSettingDynamics(String wfid) {
		return oaCtx.selectFrom(DYNAMIC).where(DYNAMIC.WFID.eq(wfid)).orderBy(DYNAMIC.ID.asc())
				.fetchInto(WorkflowSettingDynamicNode.class);
	}

}
