package com.jz.jar.oa.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.UserSkill;
import com.jz.jooq.oa.tables.records.UserSkillRecord;

@Lazy
@Repository
public class UserSkillRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.UserSkill S = Tables.USER_SKILL;

	public void updateUserSkills(String fuid, List<UserSkillRecord> skillRecords) {
		oaCtx.deleteFrom(S).where(S.UID.eq(fuid)).execute();
		oaCtx.batchInsert(skillRecords).execute();
	}

	public List<UserSkill> getUserSkills(String fuid) {
		return oaCtx.selectFrom(S).where(S.UID.eq(fuid)).orderBy(S.IDX.desc()).fetchInto(UserSkill.class);
	}

}
