package com.jz.jar.oa.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.oa.enmus.UserWorkflow;
import com.jz.jar.oa.repository.UserWorkflowAuditLogRepository;
import com.jz.jar.oa.repository.UserWorkflowHandlerRepository;
import com.jz.jar.oa.wrapper.WorkflowHandler;
import com.jz.jooq.oa.tables.pojos.UserWorkflowAuditLog;
import com.jz.jooq.oa.tables.pojos.UserWorkflowHandler;

@Lazy
@Service
public class UserWorkflowHandlerService {

	@Autowired
	private UserWorkflowHandlerRepository userWorkflowHandlerRepository;
	@Autowired
	private UserWorkflowAuditLogRepository userWorkflowAuditLogRepository;

	public void addUserWorkflowHandlers(String identify, Collection<WorkflowHandler> handlers) {
		userWorkflowHandlerRepository.addUserWorkflowHandlers(identify, handlers);
	}

	public List<UserWorkflowHandler> getUserWorkflowHandleInfos(String identify) {
		return userWorkflowHandlerRepository.getUserWorkflowHandleInfos(identify);
	}

	public void updateHandleInfo(String identify, String uid, Integer step, String position, UserWorkflow result,
			String remarks) {
		userWorkflowHandlerRepository.updateHandleInfo(identify, uid, step, position, result, remarks);
	}

	public void addUserWorkflowHandler(String identify, String uid, String handleName, int step, String reason) {
		userWorkflowHandlerRepository.addUserWorkflowHandler(identify, uid, handleName, step, reason);
	}

	public UserWorkflowHandler getUserWorkflowHandleInfo(String identify, String uid, Integer step) {
		return userWorkflowHandlerRepository.getUserWorkflowHandleInfo(identify, uid, step);
	}

	public boolean isExistCurrentUser(String identify, String uid) {
		return userWorkflowHandlerRepository.isExistCurrentUser(identify, uid);
	}

	public void cleanUserWorkflowHandles(String identify) {
		userWorkflowHandlerRepository.cleanUserWorkflowHandles(identify);
	}

	public void addAuditLog(String id, String uwfid, String operator, String handleName, String positionName,
			Integer step, UserWorkflow result, String remarks, String reason, String extType) {
		userWorkflowAuditLogRepository.addAuditLog(id, uwfid, operator, handleName, positionName, step, result, remarks,
				reason, extType);
	}

	public List<UserWorkflowAuditLog> getUserWorkflowAuditLogs(String uwfid) {
		return userWorkflowAuditLogRepository.getUserWorkflowAuditLogs(uwfid);
	}

	public List<String> getUwfidsNeedUid(String uid) {
		return userWorkflowHandlerRepository.getUwfidsNeedUid(uid);
	}

	public void updateHandler(List<String> uwfids, String uid, String taker) {
		userWorkflowHandlerRepository.updateHandler(uwfids, uid, taker);
	}
}
