package com.jz.jar.oa.wrapper;

import java.util.List;

import com.google.common.collect.Lists;
import com.jz.jooq.oa.tables.pojos.Department;

public class DepartmentWrapper {

	private String id;
	private String name;
	private Integer level;
	private Long createTime;
	private OAUserWrapper leader;
	private Integer staffNum;
	private List<DepartmentWrapper> children; // 最多2级部门
	private List<PositionWrapper> positions; // 职位

	private String parentName; // 父部门的名字
	private String rootName; // 父父部门名字

	public static DepartmentWrapper of(Department d) {
		return new DepartmentWrapper().setId(d.getId()).setName(d.getName()).setLevel(d.getLevel())
				.setCreateTime(d.getCreateTime());
	}

	public static DepartmentWrapper ofSimple(Department d) {
		return new DepartmentWrapper().setId(d.getId()).setName(d.getName());
	}

	public String getId() {
		return id;
	}

	public DepartmentWrapper setId(String id) {
		this.id = id;
		return this;
	}

	public String getName() {
		return name;
	}

	public DepartmentWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public Integer getLevel() {
		return level;
	}

	public DepartmentWrapper setLevel(Integer level) {
		this.level = level;
		return this;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public DepartmentWrapper setCreateTime(Long createTime) {
		this.createTime = createTime;
		return this;
	}

	public OAUserWrapper getLeader() {
		return leader;
	}

	public DepartmentWrapper setLeader(OAUserWrapper leader) {
		this.leader = leader;
		return this;
	}

	public Integer getStaffNum() {
		return staffNum;
	}

	public DepartmentWrapper setStaffNum(Integer staffNum) {
		this.staffNum = staffNum;
		return this;
	}

	public List<DepartmentWrapper> getChildren() {
		return children;
	}

	public DepartmentWrapper setChildren(List<DepartmentWrapper> children) {
		this.children = children;
		return this;
	}

	public DepartmentWrapper addChild(DepartmentWrapper child) {
		if (this.children == null) {
			this.children = Lists.newArrayList();
		}
		this.children.add(child);
		return this;
	}

	public List<PositionWrapper> getPositions() {
		return positions;
	}

	public DepartmentWrapper setPositions(List<PositionWrapper> positions) {
		this.positions = positions;
		return this;
	}

	public String getParentName() {
		return parentName;
	}

	public DepartmentWrapper setParentName(String parentName) {
		this.parentName = parentName;
		return this;
	}

	public String getRootName() {
		return rootName;
	}

	public DepartmentWrapper setRootName(String rootName) {
		this.rootName = rootName;
		return this;
	}

}
