package com.jz.jar.oa.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.oa.enmus.UserWorkflow;
import com.jz.jar.oa.repository.UserWorkflowListRepository;

@Lazy
@Service
public class UserWorkflowListService {

	@Autowired
	private UserWorkflowListRepository userWorkflowListRepository;

	public void addUserWorkflowList(String identify, String launch, String pendingHandler,
			Collection<String> carbonCopies) {
		userWorkflowListRepository.addUserWorkflowList(identify, launch, pendingHandler, carbonCopies);
	}

	public List<String> getUserWorkflows(String uid, int code) {
		return userWorkflowListRepository.getUserWorkflows(uid, code);
	}

	public void addPendingList(String identify, String handler) {
		userWorkflowListRepository.addPendingList(identify, handler);
	}

	public void updateType(String uid, String identify, UserWorkflow type) {
		userWorkflowListRepository.updateType(uid, identify, type);
	}

	public List<String> getContainsList(String identify, Collection<String> uids) {
		return userWorkflowListRepository.getContainsList(identify, uids);
	}

	public void addCarbonCopyList(String identify, Collection<String> ccs) {
		userWorkflowListRepository.addCarbonCopyList(identify, ccs);
	}

	public boolean isContains(String uid, String identify) {
		return userWorkflowListRepository.isContains(uid, identify);
	}

	public void cleanPendingList(String identify) {
		userWorkflowListRepository.cleanPendingList(identify);
	}

	public void deletePendingInfo(String id, String uid) {
		userWorkflowListRepository.deletePendingInfo(id, uid);
	}
}
