/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.oa.repository.OAUserRepository;
import com.jz.jooq.oa.tables.pojos.User;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class OAUserService {
    @Autowired
    private OAUserRepository userRepository;

    public void insUpdateUser(String uid, String chineseName, String englishName, String phone, String companyId, String workAddrId, String deptId, String positionId, String superiorId, String hrId, String joinDate, String relations, Integer insurance, Integer childFree, Integer trainAgreement, Integer annualLeaveDays, String certificate) {
        this.userRepository.insUpdateUser(uid, chineseName, englishName, phone, companyId, workAddrId, deptId, positionId, superiorId, hrId, joinDate, relations, insurance, childFree, trainAgreement, annualLeaveDays, certificate);
    }

    public void updateUserStatus(String uid, int status) {
        Preconditions.checkArgument((status == 1 || status == 2 ? 1 : 0) != 0, (Object)"status\u53c2\u6570\u9519\u8bef");
        this.userRepository.updateUserStatus(uid, status);
    }

    public User getUser(String uid) {
        return this.userRepository.getUser(uid);
    }

    public Map<String, User> mutiGetUserMap(Collection<String> uids) {
        List<User> list = this.userRepository.mutGetUsers(uids);
        if (ArrayMapTools.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(it -> it.getUid(), it -> it));
    }

    public Map<String, User> multiGetSimpleUser(Collection<String> uids) {
        List<User> users = this.userRepository.multiGetSimpleUser(uids);
        if (ArrayMapTools.isEmpty(users)) {
            return Maps.newHashMap();
        }
        return users.stream().collect(Collectors.toMap(it -> it.getUid(), it -> it));
    }

    public User getSimpleUser(String uid) {
        return this.userRepository.getSimpleUser(uid);
    }

    public Map<String, Integer> getStaffNumByCompanyIds(Set<String> companyIds) {
        return this.userRepository.getStaffNumByCompanyIds(companyIds);
    }

    public boolean isIncumbency(String uid) {
        return this.userRepository.isIncumbency(uid);
    }

    public int cntCompanyUser(String id) {
        return this.userRepository.cntCompanyUser(id);
    }

    public int cntDeptUser(String deptId) {
        return this.userRepository.cntDeptUser(deptId);
    }

    public int cntPositionUser(String id) {
        return this.userRepository.cntPositionUser(id);
    }

    public Map<String, Integer> getStaffNumByWorkAddressIds(Set<String> workAddressIds) {
        return this.userRepository.getStaffNumByWorkAddressIds(workAddressIds);
    }

    public int cntWorkAddressUser(String id) {
        return this.userRepository.cntWorkAddressUser(id);
    }

    public Map<String, Integer> getStaffNumByDeptIds(Set<String> deptIds) {
        return this.userRepository.getStaffNumByDeptIds(deptIds);
    }

    public void updateUserPosition(String id) {
        this.userRepository.updateUserPosition(id);
    }

    public void updateUserCompany(String id) {
        this.userRepository.updateUserCompany(id);
    }

    public void updateUserDept(String deptId) {
        this.userRepository.updateUserDept(deptId);
    }

    public List<User> getUserInfoPage(String companyId, String keyword, int start, int size) {
        return this.userRepository.getUserInfoPage(companyId, keyword, start, size);
    }

    public User getUserByPosition(String positionId) {
        return this.userRepository.getUserByPosition(positionId);
    }

    public List<String> getDeptIdsForCompany(String companyId) {
        return this.userRepository.getDeptIdsForCompany(companyId);
    }

    public List<User> getUsersForDepartment(String companyId, String deptId) {
        return this.userRepository.getUsersForDepartment(companyId, deptId);
    }

    public User getUserByPhone(String phone) {
        return this.userRepository.getUserByPhone(phone);
    }

    public String getSuperiorUid(String uid) {
        return this.userRepository.getSuperiorUid(uid);
    }

    public void updateSuperior(String currentlySuperior, String newSuperior) {
        this.userRepository.updateSuperior(currentlySuperior, newSuperior);
    }

    public void updateHr(String currentlyHr, String newHr) {
        this.userRepository.updateHr(currentlyHr, newHr);
    }

    public List<User> getUsersForWorkAddress(String workAddrId, int start, int size) {
        return this.userRepository.getUsersForWorkAddress(workAddrId, start, size);
    }

    public List<String> filterUidsByConditionsLimit(String uid, String departmentId, String companyId, String workAddrId, String keyword, int start, int size) {
        return this.userRepository.filterUidsByConditionsLimit(uid, departmentId, companyId, workAddrId, keyword, start, size);
    }

    public int cntUsersByConditions(String uid, String departmentId, String companyId, String workAddrId, String keyword) {
        return this.userRepository.cntUsersByConditions(uid, departmentId, companyId, workAddrId, keyword);
    }

    public int cntUsers(String uid, int status, String departmentId, String companyId, String workAddrId, String keyword) {
        return this.userRepository.cntUsers(uid, status, departmentId, companyId, workAddrId, keyword);
    }

    public List<User> filterUsersByConditionsLimit(String uid, int status, String departmentId, String companyId, String workAddrId, String keyword, int start, int size) {
        return this.userRepository.filterUsersByConditionsLimit(uid, status, departmentId, companyId, workAddrId, keyword, start, size);
    }
}

