/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.repository;

import com.jz.jar.oa.repository.OABaseRepository;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.Company;
import com.jz.jooq.oa.tables.records.CompanyRecord;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class OACompanyRepository
extends OABaseRepository {
    private static final Company C = Tables.COMPANY;

    public List<com.jz.jooq.oa.tables.pojos.Company> getAllCompany() {
        return this.oaCtx.selectFrom((Table)C).fetchInto(com.jz.jooq.oa.tables.pojos.Company.class);
    }

    public List<com.jz.jooq.oa.tables.pojos.Company> multiGetCompanies(Collection<String> companyIds) {
        return this.oaCtx.selectFrom((Table)C).where(new Condition[]{OACompanyRepository.C.ID.in(companyIds)}).orderBy(OACompanyRepository.C.ID.sortAsc(companyIds)).fetchInto(com.jz.jooq.oa.tables.pojos.Company.class);
    }

    public List<com.jz.jooq.oa.tables.pojos.Company> mutiGetCompanys(Collection<String> companyIds) {
        return this.oaCtx.selectFrom((Table)C).where(new Condition[]{OACompanyRepository.C.ID.in(companyIds)}).fetchInto(com.jz.jooq.oa.tables.pojos.Company.class);
    }

    public List<com.jz.jooq.oa.tables.pojos.Company> multiGetSimpleCompanies(Collection<String> companyIds) {
        return this.oaCtx.select((SelectField)OACompanyRepository.C.ID, (SelectField)OACompanyRepository.C.NAME).from((TableLike)C).where(new Condition[]{OACompanyRepository.C.ID.in(companyIds)}).fetchInto(com.jz.jooq.oa.tables.pojos.Company.class);
    }

    public com.jz.jooq.oa.tables.pojos.Company getCompany(String companyId) {
        return (com.jz.jooq.oa.tables.pojos.Company)this.oaCtx.selectFrom((Table)C).where(new Condition[]{OACompanyRepository.C.ID.eq((Object)companyId)}).fetchAnyInto(com.jz.jooq.oa.tables.pojos.Company.class);
    }

    public boolean checkName(String name) {
        return this.oaCtx.fetchExists((Table)C, OACompanyRepository.C.NAME.eq((Object)name));
    }

    public void createCompany(String id, String name, String license, String accounter, String cashier, String assetsKeeper, String law) {
        this.oaCtx.insertInto((Table)C).set((Record)new CompanyRecord(id, name, license, accounter, cashier, assetsKeeper, law, Long.valueOf(System.currentTimeMillis()))).execute();
    }

    public boolean checkExist(String companyId) {
        return this.oaCtx.fetchExists((Table)C, OACompanyRepository.C.ID.eq((Object)companyId));
    }

    public void updateCompany(String id, String name, String license, String accounter, String cashier, String assetsKeeper, String law) {
        CompanyRecord record = new CompanyRecord();
        record.setName(name);
        record.setLicense(license);
        record.setAccounter(accounter);
        record.setCashier(cashier);
        record.setAssetsKeeper(assetsKeeper);
        record.setLaw(law);
        this.oaCtx.update((Table)C).set((Record)record).where(new Condition[]{OACompanyRepository.C.ID.eq((Object)id)}).execute();
    }

    public void deleteCompany(String id) {
        this.oaCtx.deleteFrom((Table)C).where(new Condition[]{OACompanyRepository.C.ID.eq((Object)id)}).execute();
    }

    public List<com.jz.jooq.oa.tables.pojos.Company> getCompanyForAssetsManager(String assetsKeeper) {
        return this.oaCtx.select((SelectField)OACompanyRepository.C.ID, (SelectField)OACompanyRepository.C.NAME).from((TableLike)C).where(new Condition[]{OACompanyRepository.C.ASSETS_KEEPER.eq((Object)assetsKeeper)}).fetchInto(com.jz.jooq.oa.tables.pojos.Company.class);
    }

    public boolean isAssetManager(String companyId, String uid) {
        return this.oaCtx.fetchExists((Table)C, OACompanyRepository.C.ID.eq((Object)companyId).and(OACompanyRepository.C.ASSETS_KEEPER.eq((Object)uid)));
    }

    public void updateAssetsKeeper(String currentlyKeeper, String newKeeper) {
        this.oaCtx.update((Table)C).set((Field)OACompanyRepository.C.ASSETS_KEEPER, (Object)newKeeper).where(new Condition[]{OACompanyRepository.C.ASSETS_KEEPER.eq((Object)currentlyKeeper)}).execute();
    }

    public void updateAccounter(String currentlyAccounter, String newAccounter) {
        this.oaCtx.update((Table)C).set((Field)OACompanyRepository.C.ACCOUNTER, (Object)newAccounter).where(new Condition[]{OACompanyRepository.C.ACCOUNTER.eq((Object)currentlyAccounter)}).execute();
    }

    public void updateCashier(String currentlyCashier, String newCashier) {
        this.oaCtx.update((Table)C).set((Field)OACompanyRepository.C.CASHIER, (Object)newCashier).where(new Condition[]{OACompanyRepository.C.CASHIER.eq((Object)currentlyCashier)}).execute();
    }

    public void updateLaw(String currentlyLaw, String newLaw) {
        this.oaCtx.update((Table)C).set((Field)OACompanyRepository.C.LAW, (Object)newLaw).where(new Condition[]{OACompanyRepository.C.LAW.eq((Object)currentlyLaw)}).execute();
    }

    public List<com.jz.jooq.oa.tables.pojos.Company> getAllCompanySimple() {
        return this.oaCtx.select((SelectField)OACompanyRepository.C.ID, (SelectField)OACompanyRepository.C.NAME).from((TableLike)C).fetchInto(com.jz.jooq.oa.tables.pojos.Company.class);
    }
}

