/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.datetime.TimeTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.oa.cache.WorkflowIdentifyCache;
import com.jz.jar.oa.enmus.WorkflowType;
import com.jz.jar.oa.proxy.OAUserProxy;
import com.jz.jar.oa.service.OACompanyService;
import com.jz.jar.oa.service.OADepartmentService;
import com.jz.jar.oa.service.OAPositionService;
import com.jz.jar.oa.service.OAUserService;
import com.jz.jar.oa.service.OAWorkAddressService;
import com.jz.jar.oa.service.WorkflowSettingService;
import com.jz.jar.oa.wrapper.PositionWrapper;
import com.jz.jar.oa.wrapper.WorkflowHandler;
import com.jz.jooq.oa.tables.pojos.Company;
import com.jz.jooq.oa.tables.pojos.Department;
import com.jz.jooq.oa.tables.pojos.User;
import com.jz.jooq.oa.tables.pojos.WorkAddress;
import com.jz.jooq.oa.tables.pojos.WorkflowSetting;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class WorkflowProxy {
    @Autowired
    private WorkflowSettingService workflowSettingService;
    @Autowired
    private OACompanyService companyService;
    @Autowired
    private OADepartmentService departmentService;
    @Autowired
    private OAUserService userService;
    @Autowired
    private OAUserProxy userProxy;
    @Autowired
    private OAWorkAddressService workAddressService;
    @Autowired
    private OAPositionService positionService;
    @Autowired
    private WorkflowIdentifyCache workflowIdentifyCache;

    public List<WorkflowHandler> getWorkflowHandlers(String uid, List<String> companyIds, String wfid) {
        User user = this.userService.getUser(uid);
        if (null == user) {
            return null;
        }
        List<WorkflowSetting> settings = this.workflowSettingService.getWorkflowSetting(wfid);
        if (ArrayMapTools.isEmpty(settings)) {
            throw new NullPointerException("\u65e0\u6cd5\u627e\u5230\u6d41\u7a0b\u914d\u7f6e\u4fe1\u606f : [" + wfid + "]");
        }
        Department department = this.departmentService.getDepartment(user.getDeptId());
        if (null == department || StringTools.isEmpty((CharSequence)department.getLeader())) {
            throw new NullPointerException("\u65e0\u6548\u7684\u90e8\u95e8\u4fe1\u606f");
        }
        WorkAddress workAddress = this.workAddressService.getWorkAddress(user.getWorkAddrId());
        if (null == workAddress || StringTools.isEmpty((CharSequence)workAddress.getTimekeeper())) {
            throw new NullPointerException("\u65e0\u6548\u7684\u5de5\u4f5c\u5730\u70b9\u4fe1\u606f");
        }
        List<Company> companies = this.companyService.multiGetCompanies(companyIds);
        if (ArrayMapTools.isEmpty(companies)) {
            throw new NullPointerException("\u65e0\u6548\u7684\u516c\u53f8\u4fe1\u606f");
        }
        for (Company c : companies) {
            if (!StringTools.isAnyEmpty((CharSequence[])new CharSequence[]{c.getCashier(), c.getAccounter(), c.getAssetsKeeper(), c.getLaw()})) continue;
            throw new NullPointerException("\u516c\u53f8\u4fe1\u606f\u4e0d\u5b8c\u6574");
        }
        Company tempCompany = null;
        ArrayList handlers = Lists.newArrayList();
        for (WorkflowSetting workflowSetting : settings) {
            tempCompany = companies.get(workflowSetting.getCompanyIdx());
            this.addWorkflowHandler(user, department, tempCompany, workAddress, handlers, workflowSetting);
        }
        if (handlers.isEmpty()) {
            return null;
        }
        HashSet uids = Sets.newHashSet();
        handlers.forEach(it -> uids.add(it.getUid()));
        Map<String, User> users = this.userService.mutiGetUserMap(uids);
        if (ArrayMapTools.isEmpty(users)) {
            return null;
        }
        Set<String> positionIds = users.values().stream().map(User::getPositionId).collect(Collectors.toSet());
        HashMap positions = this.positionService.mutiGetSimplePositionMap(positionIds);
        if (null == positions) {
            positions = Maps.newHashMap();
        }
        ArrayList resultHandlers = Lists.newArrayList();
        ArrayList carbonCopy = Lists.newArrayList();
        int i = 0;
        for (WorkflowHandler handler : handlers) {
            if (StringTools.isEmpty((CharSequence)handler.getUid()) || !users.containsKey(handler.getUid())) {
                throw new NullPointerException("Cann't found workflow handler for [" + uid + "], [" + wfid + "], [" + handler.getHandleName() + "]");
            }
            ++i;
            User tempUser = users.get(handler.getUid());
            handler.setName(tempUser.getChineseName());
            if (handler.getIsAddPosition().booleanValue() && positions.containsKey(tempUser.getPositionId())) {
                String positionName = ((PositionWrapper)positions.get(tempUser.getPositionId())).getName();
                handler.setHandleName(handler.getHandleName() + "(" + positionName + ")");
            }
            if (handler.getIsCarbonCopy().booleanValue()) {
                carbonCopy.add(handler);
                continue;
            }
            handler.setStep(i * 10);
            resultHandlers.add(handler);
        }
        if (!carbonCopy.isEmpty()) {
            resultHandlers.addAll(carbonCopy);
        }
        return resultHandlers;
    }

    private void addWorkflowHandler(User user, Department department, Company company, WorkAddress workAddress, List<WorkflowHandler> handlers, WorkflowSetting workflowSetting) {
        if (WorkflowType.superior.equalsName(workflowSetting.getType())) {
            if (workflowSetting.getCarbonCopy() > 0) {
                List<String> carbonCopyUids = this.userProxy.getLeadersWithoutCEO(user.getSuperiorId());
                if (ArrayMapTools.isNotEmpty(carbonCopyUids)) {
                    carbonCopyUids.forEach(it -> handlers.add(WorkflowHandler.of(it, workflowSetting)));
                }
                return;
            }
            this.addSuperiorHandlers(user, workflowSetting, handlers);
        } else if (WorkflowType.finance.equalsName(workflowSetting.getType())) {
            this.addFinanceHandlers(company.getAccounter(), workflowSetting, handlers);
        } else if (WorkflowType.law.equalsName(workflowSetting.getType())) {
            handlers.add(WorkflowHandler.of(company.getLaw(), workflowSetting));
        } else if (WorkflowType.hr.equalsName(workflowSetting.getType())) {
            handlers.add(WorkflowHandler.of(user.getHrId(), workflowSetting));
        } else if (WorkflowType.cashier.equalsName(workflowSetting.getType())) {
            handlers.add(WorkflowHandler.of(company.getCashier(), workflowSetting));
        } else if (WorkflowType.assets.equalsName(workflowSetting.getType())) {
            handlers.add(WorkflowHandler.of(company.getAssetsKeeper(), workflowSetting));
        } else if (WorkflowType.attendancer.equalsName(workflowSetting.getType())) {
            handlers.add(WorkflowHandler.of(workAddress.getTimekeeper(), workflowSetting));
        } else if (WorkflowType.ceo.equalsName(workflowSetting.getType())) {
            handlers.add(WorkflowHandler.of("ohtwbdzdbqvbrlwl", workflowSetting));
        } else if (WorkflowType.self.equalsName(workflowSetting.getType())) {
            handlers.add(WorkflowHandler.of(user.getUid(), workflowSetting));
        }
    }

    private void addSuperiorHandlers(User user, WorkflowSetting workflowSetting, List<WorkflowHandler> handlers) {
        List<String> leaders;
        if (StringTools.isEmptyAndBlank((String)user.getSuperiorId())) {
            return;
        }
        handlers.add(WorkflowHandler.of(user.getSuperiorId(), workflowSetting, true));
        if ("ohtwbdzdbqvbrlwl".equals(user.getSuperiorId())) {
            return;
        }
        if (workflowSetting.getIsExt() > 0) {
            workflowSetting.setIsExt(Integer.valueOf(0));
        }
        if (ArrayMapTools.isEmpty(leaders = this.userProxy.getLeadersWithoutCEO(user.getSuperiorId()))) {
            handlers.add(WorkflowHandler.of("ohtwbdzdbqvbrlwl", workflowSetting, true));
            return;
        }
        handlers.add(WorkflowHandler.of(leaders.get(leaders.size() - 1), workflowSetting, true));
    }

    private void addFinanceHandlers(String accounter, WorkflowSetting workflowSetting, List<WorkflowHandler> handlers) {
        handlers.add(WorkflowHandler.of(accounter, workflowSetting, true));
        List<String> financeLeaders = this.userProxy.getLeadersWithoutCEO(accounter);
        if (ArrayMapTools.isEmpty(financeLeaders)) {
            return;
        }
        if (workflowSetting.getIsExt() > 0) {
            workflowSetting.setIsExt(Integer.valueOf(0));
        }
        for (String leader : financeLeaders) {
            handlers.add(WorkflowHandler.of(leader, workflowSetting, true));
        }
    }

    public String getIdentify() {
        long timeInMillis = Calendar.getInstance().getTimeInMillis();
        String today = TimeTools.getDateTime((long)timeInMillis, (String)"yyyyMMddHHmmssSSS");
        String identity = this.workflowIdentifyCache.getWorkflowIdentity();
        return today + this.append(identity, 25 - today.length());
    }

    private String append(String a, int length) {
        if (a.length() >= length) {
            return a;
        }
        return this.append("0" + a, length);
    }
}

