package com.jz.jar.oa.wrapper;

import com.jz.jooq.oa.tables.pojos.WorkAddress;

public class WorkAddressWrapper {

	private String id;
	private String name;
	private String address;
	private OAUserWrapper timekeeper;
	private String workday;
	private String checkin;
	private String checkout;
	private Long createTime;

	private Integer staffNum;

	public static WorkAddressWrapper of(WorkAddress address) {
		return new WorkAddressWrapper().setId(address.getId()).setName(address.getName())
				.setAddress(address.getAddress()).setWorkday(address.getWorkday()).setCheckin(address.getCheckin())
				.setCheckout(address.getCheckout()).setCreateTime(address.getCreateTime());
	}

	public static WorkAddressWrapper ofSimple(WorkAddress address) {
		return new WorkAddressWrapper().setId(address.getId()).setName(address.getName());
	}

	public String getId() {
		return id;
	}

	public WorkAddressWrapper setId(String id) {
		this.id = id;
		return this;
	}

	public String getName() {
		return name;
	}

	public WorkAddressWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getAddress() {
		return address;
	}

	public WorkAddressWrapper setAddress(String address) {
		this.address = address;
		return this;
	}

	public OAUserWrapper getTimekeeper() {
		return timekeeper;
	}

	public WorkAddressWrapper setTimekeeper(OAUserWrapper timekeeper) {
		this.timekeeper = timekeeper;
		return this;
	}

	public String getWorkday() {
		return workday;
	}

	public WorkAddressWrapper setWorkday(String workday) {
		this.workday = workday;
		return this;
	}

	public String getCheckin() {
		return checkin;
	}

	public WorkAddressWrapper setCheckin(String checkin) {
		this.checkin = checkin;
		return this;
	}

	public String getCheckout() {
		return checkout;
	}

	public WorkAddressWrapper setCheckout(String checkout) {
		this.checkout = checkout;
		return this;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public WorkAddressWrapper setCreateTime(Long createTime) {
		this.createTime = createTime;
		return this;
	}

	public Integer getStaffNum() {
		return staffNum;
	}

	public WorkAddressWrapper setStaffNum(Integer staffNum) {
		this.staffNum = staffNum;
		return this;
	}

}
