package com.jz.jar.oa.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.oa.enmus.UserWorkflow;
import com.jz.jar.oa.repository.UserWorkflowInfoRepository;
import com.jz.jooq.oa.tables.pojos.UserWorkflowInfo;

@Lazy
@Service
public class UserWorkflowInfoService {

	@Autowired
	private UserWorkflowInfoRepository userWorkflowInfoRepository;

	public void addOrUpdateUserWorkflowInfo(String identify, String uid, String wfid, String companyId, String title,
			String reason, String handler, Integer nextStep, String remarks, UserWorkflow workflowStatus) {
		userWorkflowInfoRepository.addOrUpdateUserWorkflowInfo(identify, uid, wfid, companyId, title, reason, handler,
				nextStep, remarks, workflowStatus);
	}

	public List<UserWorkflowInfo> mutiGetUserWorkflowInfos(Collection<String> uwfids, String keyword, int start,
			int size, Integer flowCode) {
		return userWorkflowInfoRepository.mutiGetUserWorkflowInfos(uwfids, keyword, start, size, flowCode);
	}

	public UserWorkflowInfo getUserWorkflowInfo(String id) {
		return userWorkflowInfoRepository.getUserWorkflowInfo(id);
	}

	public int cntWorkflows(List<String> uwfids, String keyword, Integer flowCode) {
		return userWorkflowInfoRepository.cntWorkflows(uwfids, keyword, flowCode);
	}

	public void updateHandleInfo(String id, String handler, Integer step, UserWorkflow status, UserWorkflow result) {
		userWorkflowInfoRepository.updateHandleInfo(id, handler, step, status, result);
	}

	public Map<String, Integer> getStatusMap(String uid) {
		return userWorkflowInfoRepository.getStatusMap(uid);
	}

	/** 获取指定流程最新的通过流程id */
	public String getLatestPassedWorkflowId(String uid, String wfid) {
		return userWorkflowInfoRepository.getLatestPassedWorkflowId(uid, wfid);
	}

	public List<String> getUserWorkflowInProgress(String uid, Collection<String> workflowKey) {
		return userWorkflowInfoRepository.getUserLeaveWorkflowInProgress(uid, workflowKey);
	}

}
