/*
 * Decompiled with CFR 0.152.
 */
package com.jz.web.mvc.common.configuration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.ErrorPage;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Component;

@Component
@Configuration
public class WebApplicationMvcRegistryConfig {
    @Bean
    public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter(ObjectMapper objectMapper) {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setObjectMapper(objectMapper);
        return converter;
    }

    @Bean
    public EmbeddedServletContainerCustomizer embeddedServletContainerCustomizer() {
        return new EmbeddedServletContainerCustomizer(){

            public void customize(ConfigurableEmbeddedServletContainer container) {
                container.addErrorPages(new ErrorPage[]{new ErrorPage(HttpStatus.BAD_REQUEST, "/400")});
                container.addErrorPages(new ErrorPage[]{new ErrorPage(HttpStatus.NOT_FOUND, "/404")});
                container.addErrorPages(new ErrorPage[]{new ErrorPage(HttpStatus.METHOD_NOT_ALLOWED, "/405")});
                container.addErrorPages(new ErrorPage[]{new ErrorPage(HttpStatus.INTERNAL_SERVER_ERROR, "/500")});
            }
        };
    }
}

