/*
 * Decompiled with CFR 0.152.
 */
package com.jz.web.mvc.common.configuration;

import com.jz.web.mvc.common.filters.HttpServletAccessFilter;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FilterRegistryConfig {
    private static Logger logger = LoggerFactory.getLogger(FilterRegistryConfig.class);
    @Value(value="${mvc.show.request.url:true}")
    private boolean showRequestUrl;

    @Bean
    public FilterRegistrationBean httpServletAccessFilter() {
        logger.info("Invocation HttpServletAccessFilter Filter Finish");
        logger.info("Spring Boot Show Request Url Service : {}", (Object)(this.showRequestUrl ? "ON" : "OFF"));
        HttpServletAccessFilter accessFilter = new HttpServletAccessFilter(this.showRequestUrl);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)accessFilter, new ServletRegistrationBean[0]);
        registrationBean.setOrder(-1);
        registrationBean.setName("httpServletRequestAccessFilter");
        registrationBean.addUrlPatterns(new String[]{"/*"});
        return registrationBean;
    }
}

