package com.jz.jar.media.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.UserRecomRepository;
import com.jz.jooq.media.tables.pojos.UserRecomAudition;
import com.jz.jooq.media.tables.pojos.UserRecomContract;

@Lazy
@Service
public class UserRecomService {

	@Autowired
	private UserRecomRepository userRecomRepository;

	public void createAudition(String puid, String brand, String suid, String schoolId, String sourcePuid,
			String sourceType, int num) {
		userRecomRepository.createAudition(puid, brand, suid, schoolId, sourcePuid, sourceType, num);
	}

	public UserRecomAudition getAudition(String puid, String brand) {
		return userRecomRepository.getAudition(puid, brand);
	}

	public int cntAuditionBySourcePuid(String sourcePuid, String brand) {
		return userRecomRepository.cntAuditionBySourcePuid(sourcePuid, brand);
	}

	public List<UserRecomAudition> getAuditionBySourcePuid(String sourcePuid, String brand, int start, int size) {
		return userRecomRepository.getAuditionBySourcePuid(sourcePuid, brand, start, size);
	}

	public void createContract(String contractId, String brand, String puid, String schoolId, String childName,
			String sourcePuid, int num) {
		userRecomRepository.createContract(contractId, brand, puid, schoolId, childName, sourcePuid, num);
	}

	public UserRecomContract getContract(String contractId, String brand) {
		return userRecomRepository.getContract(contractId, brand);
	}

	public int cntContractBySourcePuid(String sourcePuid, String brand) {
		return userRecomRepository.cntContractBySourcePuid(sourcePuid, brand);
	}

	public List<UserRecomContract> getContractBySourcePuid(String sourcePuid, String brand, int start, int size) {
		return userRecomRepository.getContractBySourcePuid(sourcePuid, brand, start, size);
	}

	public int getTotalCoinBySourcePuid(String sourcePuid, String brand) {
		int totalCoin = userRecomRepository.getAuditionCoinBySourcePuid(sourcePuid, brand);
		return totalCoin + userRecomRepository.getContractCoinBySourcePuid(sourcePuid, brand);
	}

}
