package com.jz.jar.media.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.StudentPlayMonthTotalRepository;
import com.jz.jooq.media.tables.pojos.StudentPlayMonthAttrTotal;
import com.jz.jooq.media.tables.pojos.StudentPlayMonthTotal;

@Lazy
@Service
public class StudentPlayMonthTotalService {

	@Autowired
	private StudentPlayMonthTotalRepository studentPlayMonthTotalRepository;

	public void refreshPlayTotal(BrandEnum brand, String suid, String month, int playLength, int videoCnt) {
		studentPlayMonthTotalRepository.refreshPlayTotal(brand, suid, month, playLength, videoCnt);
	}

	public void refreshAttrsPlayTotal(BrandEnum brand, String suid, String month, List<String> attrs, int playLength,
			int videoCnt) {
		studentPlayMonthTotalRepository.refreshAttrsPlayTotal(brand, suid, month, attrs, playLength, videoCnt);
	}

	public StudentPlayMonthTotal getPlayTotal(BrandEnum brand, String suid, String month) {
		return studentPlayMonthTotalRepository.getPlayTotal(brand, suid, month);
	}
	
	public int countGePlayTime(BrandEnum brand, String month, int playTime) {
		return studentPlayMonthTotalRepository.countGePlayTime(brand, month, playTime);
	}
	
	public StudentPlayMonthAttrTotal getMaxAttrPlayTotal(BrandEnum brand, String suid, String month) {
		return studentPlayMonthTotalRepository.getMaxAttrPlayTotal(brand, suid, month);
	}
}
