package com.jz.jar.media.repository;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.WorksTreasure;
import com.jz.jooq.media.tables.records.WorksTreasureRecord;

@Lazy
@Repository
public class WorksTreasureRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.WorksTreasure WT = Tables.WORKS_TREASURE;

	public void createTreasure(WorksTreasureRecord record) {
		mediaCtx.batchInsert(record).execute();
	}

	public WorksTreasure getTreasureById(String id) {
		return mediaCtx.selectFrom(WT).where(WT.ID.eq(id)).fetchAnyInto(WorksTreasure.class);
	}

	public WorksTreasure getPayedTreasureByWorkId(String workId) {
		return mediaCtx.selectFrom(WT).where(WT.WORK_ID.eq(workId).and(WT.STATUS.eq(1)))
				.fetchAnyInto(WorksTreasure.class);
	}

	public List<WorksTreasure> mutiGetPayedTreasureByWorkIds(Collection<String> workIds) {
		return mediaCtx.selectFrom(WT).where(WT.WORK_ID.in(workIds).and(WT.STATUS.eq(1)))
				.fetchInto(WorksTreasure.class);
	}

	public List<String> filterPayedWorkIds(Collection<String> workIds) {
		return mediaCtx.select(WT.WORK_ID).from(WT).where(WT.WORK_ID.in(workIds).and(WT.STATUS.eq(1)))
				.fetchInto(String.class);
	}

	public List<WorksTreasure> getRecomTreasures(int size) {
		return mediaCtx.selectFrom(WT).where(WT.RECOM.eq(1).and(WT.STATUS.eq(1))).orderBy(WT.WEIGHT.desc()).limit(size)
				.fetchInto(WorksTreasure.class);
	}

	public void finishPay(String orderId, BigDecimal payMoney, String paymentMode, String onlinePayTradeId) {
		mediaCtx.update(WT).set(WT.PAY_MONEY, payMoney).set(WT.PAYMENT_MODE, paymentMode)
				.set(WT.ONLINE_PAY_TRADE_ID, onlinePayTradeId).set(WT.STATUS, 1).set(WT.REGISTER_STATUS, 0)
				.set(WT.PAY_TIME, System.currentTimeMillis()).where(WT.ID.eq(orderId)).execute();
	}

	public int cntRecomTreasurePage() {
		return mediaCtx.fetchCount(WT, WT.RECOM.eq(1).and(WT.STATUS.eq(1)));
	}

	public List<WorksTreasure> getRecomTreasurePage(int start, int size) {
		return mediaCtx.selectFrom(WT).where(WT.RECOM.eq(1).and(WT.STATUS.eq(1))).orderBy(WT.WEIGHT.desc())
				.limit(start, size).fetchInto(WorksTreasure.class);
	}

}
