package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.Map;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class UserPhomeRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserPhome UP = Tables.USER_PHOME;

	public void freshPhomeTime(String uid, String brand) {
		long timeMillis = System.currentTimeMillis();
		mediaCtx.insertInto(UP, UP.UID, UP.BRAND, UP.LAST_PHOME_TIME).values(uid, brand, timeMillis)
				.onDuplicateKeyUpdate().set(UP.LAST_PHOME_TIME, timeMillis).execute();
	}

	public Map<String, Long> mutiGetRecentPhomeTime(Collection<String> uids, String brand) {
		return mediaCtx.select(UP.UID, UP.LAST_PHOME_TIME).from(UP).where(UP.UID.in(uids).and(UP.BRAND.eq(brand)))
				.fetchMap(UP.UID, UP.LAST_PHOME_TIME);
	}

}
