package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.SchoolWorksTopic;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class SchoolWorksTopicRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.SchoolWorksTopic SWT = Tables.SCHOOL_WORKS_TOPIC;

	public SchoolWorksTopic getTopic(String tid) {
		return mediaCtx.selectFrom(SWT).where(SWT.TID.eq(tid)).fetchAnyInto(SchoolWorksTopic.class);
	}

	public List<SchoolWorksTopic> mutiGetTopic(Collection<String> tids) {
		return mediaCtx.selectFrom(SWT).where(SWT.TID.in(tids)).fetchInto(SchoolWorksTopic.class);
	}

	public int cntAppRecomPage() {
		return mediaCtx.fetchCount(SWT, SWT.APP_RECOM.eq(1).and(SWT.STATUS.eq(1)));
	}

	public List<SchoolWorksTopic> getAppRecomPage(int start, int size) {
		return mediaCtx.selectFrom(SWT).where(SWT.APP_RECOM.eq(1).and(SWT.STATUS.eq(1)))
				.orderBy(SWT.WEIGHT.desc(), SWT.CREATE_TIME.desc(), SWT.TID.asc()).limit(start, size)
				.fetchInto(SchoolWorksTopic.class);
	}

	public List<SchoolWorksTopic> mutiGetHomeTopic(Collection<String> tids) {
		return mediaCtx.selectFrom(SWT).where(SWT.TID.in(tids).and(SWT.STATUS.eq(1))).orderBy(SWT.WEIGHT.desc())
				.fetchInto(SchoolWorksTopic.class);
	}
}
