package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserCoursePackWatch;
import com.jz.jooq.media.tables.pojos.UserCourseVideo;

@Lazy
@Repository
public class UserCourseRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserCoursePackWatch UCPW = Tables.USER_COURSE_PACK_WATCH;
	private static final com.jz.jooq.media.tables.UserCourseVideo UCV = Tables.USER_COURSE_VIDEO;

	public boolean existPackWatch(String uid, String brand, String pid) {
		return mediaCtx.fetchExists(UCPW, UCPW.UID.eq(uid).and(UCPW.BRAND.eq(brand)).and(UCPW.PID.eq(pid)));
	}

	public UserCoursePackWatch getPackWatch(String uid, String brand, String pid) {
		return mediaCtx.selectFrom(UCPW).where(UCPW.UID.eq(uid).and(UCPW.BRAND.eq(brand)).and(UCPW.PID.eq(pid)))
				.fetchAnyInto(UserCoursePackWatch.class);
	}

	public void createPackWatch(String uid, String brand, String pid) {
		mediaCtx.insertInto(UCPW, UCPW.UID, UCPW.BRAND, UCPW.PID, UCPW.CREATE_TIME)
				.values(uid, brand, pid, System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
	}

	public void updatePackWatchWid(String uid, String brand, String pid, String wid) {
		mediaCtx.update(UCPW).set(UCPW.WID, wid)
				.where(UCPW.UID.eq(uid).and(UCPW.BRAND.eq(brand)).and(UCPW.PID.eq(pid))).execute();
	}

	public int cntMyPackPage(String uid, String brand) {
		return mediaCtx.fetchCount(UCPW, UCPW.UID.eq(uid).and(UCPW.BRAND.eq(brand)));
	}

	public List<String> getMyPackIdsPage(String uid, String brand, int start, int size) {
		return mediaCtx.select(UCPW.PID).from(UCPW).where(UCPW.UID.eq(uid).and(UCPW.BRAND.eq(brand)))
				.orderBy(UCPW.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
	}

	public List<String> filterRecentWatchWids(String suid, String brand, Collection<String> wids, long minTime) {
		return mediaCtx
				.select(UCV.WID)
				.from(UCV)
				.where(UCV.SUID.eq(suid).and(UCV.BRAND.eq(brand)).and(UCV.WID.in(wids))
						.and(UCV.CREATE_TIME.ge(minTime))).fetchInto(String.class);
	}

	public List<UserCourseVideo> mutiGetUserCourseVideos(String suid, String brand, Collection<String> wids) {
		return mediaCtx.selectFrom(UCV).where(UCV.SUID.eq(suid).and(UCV.BRAND.eq(brand)).and(UCV.WID.in(wids)))
				.fetchInto(UserCourseVideo.class);
	}

	public UserCourseVideo getUserCourseVideo(String suid, String brand, String wid) {
		return mediaCtx.selectFrom(UCV).where(UCV.SUID.eq(suid).and(UCV.BRAND.eq(brand)).and(UCV.WID.eq(wid)))
				.fetchAnyInto(UserCourseVideo.class);
	}

	public void updateCourseVideoPlayLength(String suid, String brand, String wid, int playLength, int maxPlayLength) {
		long current = System.currentTimeMillis();
		mediaCtx.insertInto(UCV, UCV.SUID, UCV.BRAND, UCV.WID, UCV.PLAY_LENGTH, UCV.MAX_PLAY_LENGTH, UCV.STATUS,
				UCV.CREATE_TIME).values(suid, brand, wid, playLength, maxPlayLength, 0, current).onDuplicateKeyUpdate()
				.set(UCV.PLAY_LENGTH, playLength).set(UCV.MAX_PLAY_LENGTH, maxPlayLength).set(UCV.CREATE_TIME, current)
				.execute();
	}

	public void updateCourseVideoStatus(String suid, String brand, String wid, int status) {
		mediaCtx.insertInto(UCV, UCV.SUID, UCV.BRAND, UCV.WID, UCV.STATUS, UCV.CREATE_TIME)
				.values(suid, brand, wid, status, System.currentTimeMillis()).onDuplicateKeyUpdate()
				.set(UCV.STATUS, status).execute();
	}

	public List<Map<String, Object>> mutiCalFinishCnt(String suid, String brand, Collection<String> pids) {
		String sql = "SELECT pid,COUNT(1) AS num" + " FROM(" + " SELECT wid,pid" + " FROM `tomato_course_pack_video`"
				+ " WHERE pid IN(" + StringUtils.join(Collections.nCopies(pids.size(), "?"), ",") + ")"
				+ " )t1 INNER JOIN(" + " SELECT `wid`" + " FROM `user_course_video`"
				+ " WHERE suid=? AND brand=? AND `status` in(1,2)" + " )t2 ON t1.wid=t2.wid" + " GROUP BY pid";
		List<Object> args = Lists.newArrayList();
		args.addAll(pids);
		args.add(suid);
		args.add(brand);
		return mediaJdbcTemplate.queryForList(sql, args.toArray());
	}

	public List<Map<String, Object>> mutiCalFinishCntBySuids(Collection<String> suids, String brand,
			Collection<String> pids) {
		String sql = "SELECT pid,COUNT(1) AS num" + " FROM(" + " SELECT wid,pid" + " FROM `tomato_course_pack_video`"
				+ " WHERE pid IN(" + StringUtils.join(Collections.nCopies(pids.size(), "?"), ",") + ")"
				+ " )t1 INNER JOIN(" + " SELECT `wid`" + " FROM `user_course_video`" + " WHERE suid IN("
				+ StringUtils.join(Collections.nCopies(suids.size(), "?"), ",") + ") AND brand=? AND `status` in(1,2)"
				+ " )t2 ON t1.wid=t2.wid" + " GROUP BY pid";
		List<Object> args = Lists.newArrayList();
		args.addAll(pids);
		args.addAll(suids);
		args.add(brand);
		return mediaJdbcTemplate.queryForList(sql, args.toArray());
	}

}
