/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.enums.DbField;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.TomatoCoursePack;
import com.jz.jooq.media.tables.pojos.TomatoCoursePackVideo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class TomatoCoursePackRepository
extends MediaBaseRepository {
    private static final TomatoCoursePack TCP = Tables.TOMATO_COURSE_PACK;
    private static final com.jz.jooq.media.tables.TomatoCoursePackVideo TCPV = Tables.TOMATO_COURSE_PACK_VIDEO;

    public com.jz.jooq.media.tables.pojos.TomatoCoursePack getOnlinePack(String pid, String brand) {
        return (com.jz.jooq.media.tables.pojos.TomatoCoursePack)this.mediaCtx.selectFrom((Table)TCP).where(new Condition[]{TomatoCoursePackRepository.TCP.PID.eq((Object)pid).and(TomatoCoursePackRepository.TCP.BRAND.eq((Object)brand)).and(TomatoCoursePackRepository.TCP.STATUS.eq((Object)DbField.online.name()))}).fetchAnyInto(com.jz.jooq.media.tables.pojos.TomatoCoursePack.class);
    }

    public com.jz.jooq.media.tables.pojos.TomatoCoursePack getOnlinePack(String pid) {
        return (com.jz.jooq.media.tables.pojos.TomatoCoursePack)this.mediaCtx.selectFrom((Table)TCP).where(new Condition[]{TomatoCoursePackRepository.TCP.PID.eq((Object)pid).and(TomatoCoursePackRepository.TCP.STATUS.eq((Object)DbField.online.name()))}).fetchAnyInto(com.jz.jooq.media.tables.pojos.TomatoCoursePack.class);
    }

    public List<com.jz.jooq.media.tables.pojos.TomatoCoursePack> mutiGetOnlinePack(Collection<String> pids, String brand) {
        return this.mediaCtx.selectFrom((Table)TCP).where(new Condition[]{TomatoCoursePackRepository.TCP.PID.in(pids).and(TomatoCoursePackRepository.TCP.BRAND.eq((Object)brand)).and(TomatoCoursePackRepository.TCP.STATUS.eq((Object)DbField.online.name()))}).fetchInto(com.jz.jooq.media.tables.pojos.TomatoCoursePack.class);
    }

    public Map<String, String> mutiGetPackName(Collection<String> pids) {
        return this.mediaCtx.select((SelectField)TomatoCoursePackRepository.TCP.PID, (SelectField)TomatoCoursePackRepository.TCP.NAME).from((TableLike)TCP).where(new Condition[]{TomatoCoursePackRepository.TCP.PID.in(pids)}).fetchMap((Field)TomatoCoursePackRepository.TCP.PID, (Field)TomatoCoursePackRepository.TCP.NAME);
    }

    public List<com.jz.jooq.media.tables.pojos.TomatoCoursePack> mutiGetOnlinePack(Collection<String> pids) {
        return this.mediaCtx.selectFrom((Table)TCP).where(new Condition[]{TomatoCoursePackRepository.TCP.PID.in(pids).and(TomatoCoursePackRepository.TCP.STATUS.eq((Object)DbField.online.name()))}).fetchInto(com.jz.jooq.media.tables.pojos.TomatoCoursePack.class);
    }

    public List<TomatoCoursePackVideo> getPackVideos(String pid) {
        return this.mediaCtx.selectFrom((Table)TCPV).where(new Condition[]{TomatoCoursePackRepository.TCPV.PID.eq((Object)pid)}).orderBy(TomatoCoursePackRepository.TCPV.SEQ.asc()).fetchInto(TomatoCoursePackVideo.class);
    }

    public List<TomatoCoursePackVideo> mutiGetPackVideos(Collection<String> pids) {
        return this.mediaCtx.selectFrom((Table)TCPV).where(new Condition[]{TomatoCoursePackRepository.TCPV.PID.in(pids)}).orderBy(TomatoCoursePackRepository.TCPV.PID.asc(), TomatoCoursePackRepository.TCPV.SEQ.asc()).fetchInto(TomatoCoursePackVideo.class);
    }

    public List<String> getPackVideoWids(String pid) {
        return this.mediaCtx.select((SelectField)TomatoCoursePackRepository.TCPV.WID).from((TableLike)TCPV).where(new Condition[]{TomatoCoursePackRepository.TCPV.PID.eq((Object)pid)}).orderBy(TomatoCoursePackRepository.TCPV.SEQ.asc()).fetchInto(String.class);
    }

    public void increStudyCnt(String pid, int num) {
        this.mediaCtx.update((Table)TCP).set((Field)TomatoCoursePackRepository.TCP.STUDY_CNT, TomatoCoursePackRepository.TCP.STUDY_CNT.add((Number)num)).where(new Condition[]{TomatoCoursePackRepository.TCP.PID.eq((Object)pid)}).execute();
    }

    public TomatoCoursePackVideo getPackVideo(String wid, String pid) {
        return (TomatoCoursePackVideo)this.mediaCtx.selectFrom((Table)TCPV).where(new Condition[]{TomatoCoursePackRepository.TCPV.WID.eq((Object)wid).and(TomatoCoursePackRepository.TCPV.PID.eq((Object)pid))}).fetchAnyInto(TomatoCoursePackVideo.class);
    }

    public int cntOnlineOnSalePackPage(String brand, int type) {
        return this.mediaCtx.fetchCount((Table)TCP, TomatoCoursePackRepository.TCP.BRAND.eq((Object)brand).and(TomatoCoursePackRepository.TCP.STATUS.eq((Object)DbField.online.name())).and(TomatoCoursePackRepository.TCP.SALE_STATUS.eq((Object)1)).and(TomatoCoursePackRepository.TCP.TYPE.eq((Object)type)));
    }

    public List<String> getOnlineOnSalePidsPage(String brand, int type, int start, int size) {
        return this.mediaCtx.select((SelectField)TomatoCoursePackRepository.TCP.PID).from((TableLike)TCP).where(new Condition[]{TomatoCoursePackRepository.TCP.BRAND.eq((Object)brand).and(TomatoCoursePackRepository.TCP.STATUS.eq((Object)DbField.online.name())).and(TomatoCoursePackRepository.TCP.SALE_STATUS.eq((Object)1)).and(TomatoCoursePackRepository.TCP.TYPE.eq((Object)type))}).orderBy(TomatoCoursePackRepository.TCP.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<String> getPidsByWid(String wid) {
        return this.mediaCtx.select((SelectField)TomatoCoursePackRepository.TCPV.PID).from((TableLike)TCPV).where(new Condition[]{TomatoCoursePackRepository.TCPV.WID.eq((Object)wid)}).fetchInto(String.class);
    }

    public List<com.jz.jooq.media.tables.pojos.TomatoCoursePack> getAllSimplePack(String brand) {
        return this.mediaCtx.select((SelectField)TomatoCoursePackRepository.TCP.PID, (SelectField)TomatoCoursePackRepository.TCP.NAME).from((TableLike)TCP).where(new Condition[]{TomatoCoursePackRepository.TCP.BRAND.eq((Object)brand)}).fetchInto(com.jz.jooq.media.tables.pojos.TomatoCoursePack.class);
    }

    public Integer cntMaster(Collection<String> wids, String pid) {
        return (Integer)this.mediaCtx.select((SelectField)DSL.countDistinct((Field)TomatoCoursePackRepository.TCPV.SERIE_ID)).from((TableLike)TCPV).where(new Condition[]{TomatoCoursePackRepository.TCPV.WID.in(wids).and(TomatoCoursePackRepository.TCPV.PID.eq((Object)pid))}).fetchAnyInto(Integer.class);
    }

    public Integer cntByKeywordPage(String brand, String keyword) {
        return this.mediaCtx.fetchCount((Table)TCP, this.genByKeywordPageWhere(brand, keyword));
    }

    public List<String> getByKeywordPage(String brand, String keyword, int start, int size) {
        return this.mediaCtx.select((SelectField)TomatoCoursePackRepository.TCP.PID).from((TableLike)TCP).where(new Condition[]{this.genByKeywordPageWhere(brand, keyword)}).orderBy(TomatoCoursePackRepository.TCP.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }

    private Condition genByKeywordPageWhere(String brand, String keyword) {
        return TomatoCoursePackRepository.TCP.BRAND.eq((Object)brand).and(TomatoCoursePackRepository.TCP.STATUS.eq((Object)DbField.online.name())).and(TomatoCoursePackRepository.TCP.SALE_STATUS.eq((Object)1)).and(TomatoCoursePackRepository.TCP.NAME.like("%" + keyword + "%"));
    }
}

