/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.cache;

import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.tables.pojos.MediaVideo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisCluster;

@Lazy
@Component
public class MediaVideoCache {
    private static final Logger logger = LoggerFactory.getLogger(MediaVideoCache.class);
    private static final int expireSeconds = 600;
    @Autowired
    private JedisCluster jedisCluster;

    private String key(String wid, BrandEnum brand) {
        return new StringBuffer().append(brand.name()).append(":mv:").append(wid).toString();
    }

    public void setMediaVideo(MediaVideo video, BrandEnum brand) {
        try {
            this.jedisCluster.set(this.key(video.getWid(), brand), GsonTools.gson.toJson((Object)video), "nx", "ex", 600L);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public MediaVideo getMediaVideo(String wid, BrandEnum brand) {
        try {
            String value = this.jedisCluster.get(this.key(wid, brand));
            if (StringTools.isEmpty((CharSequence)value)) {
                return null;
            }
            return (MediaVideo)GsonTools.gson.fromJson(value, MediaVideo.class);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

