package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.AuditStatus;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.DbField;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.MediaBanner;

@Lazy
@Repository
public class MediaBannerRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.MediaBanner MB = Tables.MEDIA_BANNER;

	public List<MediaBanner> findOnlineBanners(BrandEnum brand, DbField bpg, boolean isMini, String ver) {
		return mediaCtx
				.select(MB.ID, MB.TYPE, MB.SOURCE, MB.PIC, MB.RATIO, MB.TITLE, MB.DESC, MB.SEQ, MB.MIN_APP_VERSION,
						MB.POP_UP, MB.PACK_TYPE)
				.from(MB)
				.where(MB.SHOW_PAGE.eq(bpg.name()).and(MB.MINI.in(0, (isMini ? 2 : 1))).and(MB.BRAND.eq(brand.name()))
						.and(MB.STATUS.eq(AuditStatus.online.getCode())).and(MB.VER.eq(ver))).orderBy(MB.SEQ.asc())
				.fetchInto(MediaBanner.class);
	}

}
