package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.MediaVideoStatus;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.MediaVideo;
import com.jz.jooq.media.tables.records.MediaVideoRecord;

@Lazy
@Repository
public class MediaVideoRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.MediaVideo VIDEO = Tables.MEDIA_VIDEO;

	public MediaVideo getVideo(String wid, BrandEnum brand) {
		return mediaCtx.selectFrom(VIDEO).where(VIDEO.WID.eq(wid).and(VIDEO.BRAND.eq(brand.name()))
				.and(VIDEO.STATUS.eq(MediaVideoStatus.online.getCode()))).fetchAnyInto(MediaVideo.class);
	}

	public List<MediaVideo> findVideos(Collection<String> wids) {
		return mediaCtx.selectFrom(VIDEO)
				.where(VIDEO.WID.in(wids).and(VIDEO.STATUS.eq(MediaVideoStatus.online.getCode())))
				.fetchInto(MediaVideo.class);
	}

	public void saveOrUpdateVideo(MediaVideoRecord mediaVideoRecord) {
		mediaCtx.insertInto(VIDEO).set(mediaVideoRecord).onDuplicateKeyUpdate().set(mediaVideoRecord).execute();
	}

	public boolean isExist(String wid, BrandEnum brand) {
		return mediaCtx.fetchExists(VIDEO, VIDEO.WID.eq(wid).and(VIDEO.BRAND.eq(brand.name())));
	}

	public boolean isOnlineExist(String wid, BrandEnum brand) {
		return mediaCtx.fetchExists(VIDEO, VIDEO.WID.eq(wid).and(VIDEO.BRAND.eq(brand.name()))
				.and(VIDEO.STATUS.eq(MediaVideoStatus.online.getCode())));
	}

	public void addWatchCnt(String wid, BrandEnum brand, int cnt) {
		mediaCtx.update(VIDEO).set(VIDEO.WATCH_CNT, VIDEO.WATCH_CNT.add(cnt))
				.set(VIDEO.LAST_UPDATE, System.currentTimeMillis())
				.where(VIDEO.WID.eq(wid).and(VIDEO.BRAND.eq(brand.name()))).execute();
	}

	public List<String> filterOnlineVideo(Collection<String> wids, BrandEnum brand) {
		return mediaCtx.select(VIDEO.WID).from(VIDEO).where(VIDEO.WID.in(wids).and(VIDEO.BRAND.eq(brand.name()))
				.and(VIDEO.STATUS.eq(MediaVideoStatus.online.getCode()))).fetchInto(String.class);
	}
}
