package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TomatoCourseWorks;
import com.jz.jooq.media.tables.pojos.TomatoCourseWorksScore;
import com.jz.jooq.media.tables.pojos.TomatoCourseWorksScoreSetting;

@Lazy
@Repository
public class TomatoCourseWorksRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TomatoCourseWorks TCW = Tables.TOMATO_COURSE_WORKS;
	private static final com.jz.jooq.media.tables.TomatoCourseWorksScore TCWS = Tables.TOMATO_COURSE_WORKS_SCORE;
	private static final com.jz.jooq.media.tables.TomatoCourseWorksScoreSetting TCWSS = Tables.TOMATO_COURSE_WORKS_SCORE_SETTING;

	public TomatoCourseWorks getWorksByWidSuid(String wid, String suid) {
		return mediaCtx.selectFrom(TCW).where(TCW.WID.eq(wid).and(TCW.SUID.eq(suid)))
				.fetchAnyInto(TomatoCourseWorks.class);
	}

	public List<TomatoCourseWorksScoreSetting> listScoreSettings() {
		return mediaCtx.selectFrom(TCWSS).fetchInto(TomatoCourseWorksScoreSetting.class);
	}

	public List<TomatoCourseWorksScore> getWorksScore(String worksId) {
		return mediaCtx.selectFrom(TCWS).where(TCWS.WORKS_ID.eq(worksId)).fetchInto(TomatoCourseWorksScore.class);
	}

	public void updatePics(String id, String pics) {
		mediaCtx.update(TCW).set(TCW.PICS, pics).where(TCW.ID.eq(id)).execute();
	}

	public void createWorks(String id, String wid, String suid, String uid, String pid, String pics) {
		mediaCtx.insertInto(TCW, TCW.ID, TCW.WID, TCW.SUID, TCW.PUID, TCW.PID, TCW.PICS, TCW.STATUS, TCW.CREATE_TIME)
				.values(id, wid, suid, uid, pid, pics, 0, System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
	}
}
