/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.service;

import com.google.common.collect.Maps;
import com.jz.jar.media.repository.UserCoinTaskRepository;
import com.jz.jar.media.service.UserCoinService;
import com.jz.jooq.media.tables.pojos.UserCoinTaskSetting;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Lazy
@Service
@EnableScheduling
public class UserCoinTaskService {
    private static final Logger logger = LoggerFactory.getLogger(UserCoinTaskService.class);
    @Autowired
    private UserCoinTaskRepository userCoinTaskRepository;
    @Autowired
    private UserCoinService userCoinService;
    public static Map<String, UserCoinTaskSetting> taskSettingMap = Maps.newHashMap();

    @PostConstruct
    @Scheduled(cron="0 */5 * * * ?")
    public void cacheTask() {
        try {
            Map<String, UserCoinTaskSetting> taskSettingMapTemp = this.userCoinTaskRepository.listSettings().stream().collect(Collectors.toMap(t -> t.getId(), t -> t));
            taskSettingMap = taskSettingMapTemp;
            logger.info("taskSettingMap.size:" + taskSettingMap.size());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public Integer dealTask(String uid, String taskId) {
        UserCoinTaskSetting task = taskSettingMap.get(taskId);
        if (task == null || task.getNum() <= 0) {
            return null;
        }
        if (task.getType() == 1) {
            if (this.userCoinTaskRepository.isExistTaskRecord(uid, taskId)) {
                return null;
            }
            this.userCoinTaskRepository.createTaskRecord(uid, taskId, task.getNum());
            this.userCoinService.updateUserCoin(uid, task.getNum(), task.getName());
            return task.getNum();
        }
        return null;
    }
}

