package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.AuditStatus;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.WorksTheme;

@Lazy
@Repository
public class WorksThemeRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.WorksTheme WT = Tables.WORKS_THEME;

	private Condition getOnlineCondition() {
		return WT.STATUS.eq(AuditStatus.online.getCode()).and(WT.WORKS_CNT.gt(0));
	}

	public int countOnlineWorksTheme() {
		return mediaCtx.fetchCount(WT, getOnlineCondition());
	}

	public List<String> getOnlineWorksThemeIds(int start, int size) {
		return mediaCtx.select(WT.ID).from(WT).where(getOnlineCondition()).orderBy(WT.SEQ.desc()).limit(start, size)
				.fetchInto(String.class);
	}

	public List<WorksTheme> findWorksThemeInfo(Collection<String> ids) {
		return mediaCtx.selectFrom(WT).where(WT.ID.in(ids)).orderBy(WT.SEQ.desc()).fetchInto(WorksTheme.class);
	}

	public void addWorksCnt(Collection<String> ids, int cnt) {
		mediaCtx.update(WT).set(WT.WORKS_CNT, WT.WORKS_CNT.add(cnt)).where(WT.ID.in(ids)).execute();
	}
}
