package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.QuizQuestion;

@Lazy
@Repository
public class QuizQuestionRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.QuizQuestion QQ = Tables.QUIZ_QUESTION;

	public List<QuizQuestion> getQuestionForQuiz(String qzid) {
		return mediaCtx.selectFrom(QQ).where(QQ.QZID.eq(qzid)).fetchInto(QuizQuestion.class);
	}

}
