package com.jz.jar.media.service;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.DbField;
import com.jz.jar.media.repository.CommonPlayHistoryRepository;
import com.jz.jooq.media.tables.pojos.CommonPlayHistory;

@Lazy
@Service
public class CommonPlayHistoryService {

	private static final SimpleDateFormat yearMonthDay = new SimpleDateFormat("yyyyMMdd");

	@Autowired
	private CommonPlayHistoryRepository commonPlayHistoryRepository;

	public void save(String commonKey, String pid, String wid) {
		commonPlayHistoryRepository.save(commonKey, pid, wid);
	}

	public boolean isExist(String commonKey, String pid, String wid) {
		return commonPlayHistoryRepository.isExist(commonKey, pid, wid);
	}

	public List<CommonPlayHistory> findPlayHistories(String commonKey, Collection<String> pidArray) {
		return commonPlayHistoryRepository.findPlayHistories(commonKey, pidArray);
	}

	public String getCommonKey(String suid, DbField field) {
		if (DbField.special == field) // 专项练习
			return "zxlx:" + suid;
		// 每日任务
		if (DbField.everday == field)
			return yearMonthDay.format(Calendar.getInstance().getTime()) + ":" + suid;
		return null;
	}
}
