package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserNotice;

@Lazy
@Repository
public class UserNoticeRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserNotice UN = Tables.USER_NOTICE;

	public void save(String uid, String content) {
		mediaCtx.insertInto(UN, UN.UID, UN.CONTENT, UN.CREATED)
				.values(uid, content, System.currentTimeMillis())
				.execute();
	}

	public int countNotices(String uid, long timestamp) {
		return mediaCtx.fetchCount(UN, UN.UID.eq(uid).and(UN.CREATED.ge(timestamp)));
	}

	public List<UserNotice> findNotices(String uid, int start, int size) {
		return mediaCtx.selectFrom(UN).where(UN.UID.eq(uid))
				.orderBy(UN.CREATED.desc()).limit(start, size).fetchInto(UserNotice.class);
	}
}
