package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.jooq.Record2;
import org.jooq.Result;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.Playlist;

@Lazy
@Repository
public class PlaylistRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.Playlist PL = Tables.PLAYLIST;

	public Playlist getPlaylist(String pid) {
		List<Playlist> playlists = mediaCtx.selectFrom(PL).where(PL.PID.eq(pid)).fetchInto(Playlist.class);
		return ArrayMapTools.isNotEmpty(playlists) ? playlists.get(0) : null;
	}

	public List<Playlist> getPlaylist(Collection<String> pids) {
		return mediaCtx.selectFrom(PL).where(PL.PID.in(pids)).fetchInto(Playlist.class);
	}

	public List<Playlist> getPlaylist(int start, int size) {
		return mediaCtx.selectFrom(PL).orderBy(PL.UPDATE_TIME.desc()).limit(start, size).fetchInto(Playlist.class);
	}
	
	public Map<String, Integer> getPlaylistToVideoCount(Collection<String> pids) {
		Result<Record2<String, Integer>> result = mediaCtx.select(PL.PID, PL.VIDEO_CNT).from(PL).where(PL.PID.in(pids)).fetch();
		if (null == result || result.isEmpty())
			return Maps.newHashMap();
		Map<String, Integer> pid2VideoCount = Maps.newHashMap();
		result.forEach(it -> pid2VideoCount.put(it.value1(), it.value2()));
		return pid2VideoCount;
	}
}
