package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.Video;

@Lazy
@Repository
public class MediaVideoRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.Video VIDEO = Tables.VIDEO;

	public Video getVideo(String wid) {
		List<Video> videos = mediaCtx.selectFrom(VIDEO).where(VIDEO.WID.eq(wid)).fetchInto(Video.class);
		return ArrayMapTools.isNotEmpty(videos) ? videos.get(0) : null;
	}

	public List<Video> findVideos(Collection<String> wids) {
		return mediaCtx.selectFrom(VIDEO).where(VIDEO.WID.in(wids)).fetchInto(Video.class);
	}
}
