/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.service.PlaylistRelationService;
import com.jz.jooq.media.tables.pojos.PlaylistRelation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Lazy
@Service
@EnableScheduling
public class PlaylistRelationProxy {
    private static final Map<String, List<String>> cacheLevel2Topics = Maps.newHashMap();
    @Autowired
    private PlaylistRelationService playlistRelationService;

    @PostConstruct
    @Scheduled(cron="0 */5 * * * ?")
    public void loadRelationToCache() {
        List relations = this.playlistRelationService.findLevelTopics();
        if (ArrayMapTools.isEmpty((Collection)relations)) {
            return;
        }
        HashMap levelToTopics = Maps.newHashMap();
        for (PlaylistRelation r : relations) {
            if (!levelToTopics.containsKey(r.getLid())) {
                levelToTopics.put(r.getLid(), Lists.newArrayList());
            }
            ((List)levelToTopics.get(r.getLid())).add(r.getCid());
        }
        cacheLevel2Topics.clear();
        cacheLevel2Topics.putAll(levelToTopics);
    }

    public List<String> getLevelIds() {
        return Lists.newArrayList(cacheLevel2Topics.keySet());
    }

    public List<String> getTopicsForLevel(String lid) {
        return Lists.newArrayList((Iterable)cacheLevel2Topics.get(lid));
    }

    public List<String> getTopicsForLevel(Collection<String> lids) {
        HashSet cids = Sets.newHashSet();
        lids.forEach(lid -> cids.addAll((Collection)cacheLevel2Topics.get(lid)));
        return Lists.newArrayList((Iterable)cids);
    }
}

