package com.jz.jar.media.proxy;

import java.util.List;
import java.util.Map;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.service.LevelService;
import com.jz.jooq.media.tables.pojos.Level;

@Lazy
@Service
@EnableScheduling
public class LevelProxy {

	private static final Map<String, Level> levelArray = Maps.newLinkedHashMap();

	@Autowired
	private LevelService levelService;

	/** 加载级别到缓存中 */
	@PostConstruct
	@Scheduled(cron = "0 */5 * * * ?")
	public void loadLevelCache() {
		List<Level> levels = levelService.find();
		if (ArrayMapTools.isEmpty(levels)) {
			return;
		}
		levelArray.clear();
		levels.forEach(it -> levelArray.put(it.getLid(), it));
	}

	public List<Level> getLevels(List<String> lidArray) {
		List<Level> levels = Lists.newArrayList();
		levelArray.forEach((k, v) -> {
			if (lidArray.contains(k))
				levels.add(v);
		});
		return levels;
	}

	public Level getLevelForAge(double age) {
		for (Level le : levelArray.values()) {
			if (le.getMinAge() <= age && age <= le.getMaxAge()) {
				return le;
			}
		}
		return null;
	}

}
