package com.jz.live.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.live.Tables;
import com.jz.jooq.live.tables.pojos.LiveInfo;

@Lazy
@Repository
public class LiveInfoRepository extends LiveBaseRepository {

	private static final com.jz.jooq.live.tables.LiveInfo LI = Tables.LIVE_INFO;

	public List<LiveInfo> mutiGetLiveInfo(Collection<String> lids) {
		return liveCtx.selectFrom(LI).where(LI.LID.in(lids).and(LI.STATUS.ge(0))).fetchInto(LiveInfo.class);
	}

	public LiveInfo getLiveInfo(String lid) {
		return liveCtx.selectFrom(LI).where(LI.LID.eq(lid).and(LI.STATUS.ge(0))).fetchAnyInto(LiveInfo.class);
	}

	public List<LiveInfo> mutiGetLivingInfo(Collection<String> lids) {
		return liveCtx.selectFrom(LI).where(LI.LID.in(lids).and(LI.STATUS.eq(1))).fetchInto(LiveInfo.class);
	}

	public List<LiveInfo> mutiGetLiveInfoInTime(Collection<String> lids, long startTime, long endTime) {
		return liveCtx.selectFrom(LI)
				.where(LI.LID.in(lids).and(LI.STATUS.ge(0)).and(LI.PLAN_START_TIME.between(startTime, endTime)))
				.fetchInto(LiveInfo.class);
	}
}
