package com.jz.jar.join.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.join.Tables;
import com.jz.jooq.franchise.join.tables.pojos.ApplyUser;

/**
 * @Title ApplyUserRepository
 * @Package com.jz.jar.join.repository
 * @author tangjunfeng
 * @date 2018年11月21日 上午10:00:24
 * @version V1.0
 */
@Lazy
@Repository
public class ApplyUserRepository extends JoinBaseRepository {

	private static final com.jz.jooq.franchise.join.tables.ApplyUser AU = Tables.APPLY_USER;

	public void save(ApplyUser user) {
		joinCtx.insertInto(AU).set(joinCtx.newRecord(AU, user)).onDuplicateKeyIgnore().execute();
	}

	public ApplyUser getUserForPhone(String phone) {
		return joinCtx.selectFrom(AU).where(AU.PHONE.eq(phone)).fetchAnyInto(ApplyUser.class);
	}
}
