package com.jz.gymchina.jar.resources.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.gymchina.resources.Tables;

@Lazy
@Repository
public class TransCodeRepository extends ResourceBaseRepository {

	private static com.jz.jooq.gymchina.resources.tables.TransCode TC = Tables.TRANS_CODE;

	public void refreshTransCode(String jobId, String fileId) {
		resourcesCtx.insertInto(TC, TC.JOB_ID, TC.FILE_ID).values(jobId, fileId).onDuplicateKeyUpdate()
				.set(TC.FILE_ID, fileId).execute();
	}

	public boolean isExistTransCode(String jobId) {
		return resourcesCtx.fetchExists(TC, TC.JOB_ID.eq(jobId));
	}

	public String getFileId(String jobId) {
		return resourcesCtx.select(TC.FILE_ID).from(TC).where(TC.JOB_ID.eq(jobId)).fetchAnyInto(String.class);
	}

	public void deleteFile(String jobId) {
		resourcesCtx.deleteFrom(TC).where(TC.JOB_ID.eq(jobId)).execute();
	}

}
