/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.collection.OrderTool;
import com.jz.jar.franchise.enums.ContractParentSignStatus;
import com.jz.jar.franchise.repository.ContractPostponeRepository;
import com.jz.jar.franchise.repository.ContractRepository;
import com.jz.jar.franchise.repository.ContractTermsRepository;
import com.jz.jar.franchise.repository.StudentInfoRepository;
import com.jz.jar.franchise.repository.StudentSchoolContractRepository;
import com.jz.jar.franchise.service.ContractCompanyService;
import com.jz.jar.franchise.service.CoursePackService;
import com.jz.jar.franchise.service.CourseService;
import com.jz.jar.franchise.service.FUserInfoService;
import com.jz.jar.franchise.service.ParentInfoService;
import com.jz.jar.franchise.service.SchoolService;
import com.jz.jar.franchise.service.StudentSchoolService;
import com.jz.jar.franchise.wrapper.ContractPostponeWrapper;
import com.jz.jar.franchise.wrapper.ContractStudentWrapper;
import com.jz.jar.franchise.wrapper.ContractWrapper;
import com.jz.jar.franchise.wrapper.CourseWrapper;
import com.jz.jar.franchise.wrapper.SchoolWrapper;
import com.jz.jar.franchise.wrapper.UserSimpleWrapper;
import com.jz.jooq.franchise.tables.pojos.Contract;
import com.jz.jooq.franchise.tables.pojos.ContractCompany;
import com.jz.jooq.franchise.tables.pojos.ContractDetail;
import com.jz.jooq.franchise.tables.pojos.ContractPostpone;
import com.jz.jooq.franchise.tables.pojos.ContractTerms;
import com.jz.jooq.franchise.tables.pojos.School;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;
import com.jz.jooq.franchise.tables.pojos.StudentSchoolContract;
import com.jz.jooq.franchise.tables.pojos.StudentSchoolExtra;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ContractService {
    private Logger logger = LoggerFactory.getLogger(ContractService.class);
    @Autowired
    private ContractRepository contractRepository;
    @Autowired
    private StudentSchoolContractRepository studentSchoolContractRepository;
    @Autowired
    private FUserInfoService fUserInfoService;
    @Autowired
    private CourseService courseService;
    @Autowired
    private CoursePackService coursePackService;
    @Autowired
    private ParentInfoService parentInfoService;
    @Autowired
    private StudentInfoRepository studentInfoRepository;
    @Autowired
    private ContractPostponeRepository contractPostponeRepository;
    @Autowired
    private ContractTermsRepository contractTermsRepository;
    @Autowired
    private ContractCompanyService contractCompanyService;
    @Autowired
    private SchoolService schoolService;
    @Autowired
    private StudentSchoolService studentSchoolService;

    public Contract getContract(String brandId, String contractId) {
        return this.contractRepository.getContractForBranch(brandId, contractId);
    }

    public Pair<ContractWrapper, SchoolWrapper> getContractDetailWrapper(String contractId, String schoolId, School school) {
        ContractCompany cc;
        List<ContractPostpone> postpones;
        Contract contract = this.contractRepository.getContract(contractId, schoolId);
        ContractDetail contractDetail = this.contractRepository.getContractDetail(contractId, schoolId);
        if (contract == null) {
            this.logger.error("\u83b7\u53d6\u4e0d\u5230\u5408\u540c\u4fe1\u606f");
            return null;
        }
        if (contractDetail == null) {
            this.logger.error("\u5408\u540c\u4fe1\u606f\u7f3a\u5931\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return null;
        }
        ContractWrapper contractWrapper = ContractWrapper.of(contract);
        contractWrapper.setContractDetail(contractDetail);
        List<StudentSchoolContract> sscs = this.studentSchoolContractRepository.getSSCByContractId(schoolId, contractId);
        if (ArrayMapTools.isEmpty(sscs)) {
            this.logger.error("\u5408\u540c\u5b66\u751f\u4fe1\u606f\u7f3a\u5931\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return null;
        }
        ArrayList students = Lists.newArrayList();
        for (StudentSchoolContract ssc : sscs) {
            StudentInfo si = this.studentInfoRepository.getStudent(ssc.getSuid());
            if (si == null) {
                this.logger.warn("\u5408\u540c\u5b66\u5458\u4fe1\u606f\u4e0d\u5b58\u5728:" + ssc.getSuid());
                return null;
            }
            students.add(ContractStudentWrapper.ofStudentInfo(si));
        }
        contractWrapper.setStudents(students);
        contractWrapper.setParent(this.parentInfoService.getParentWrapper(contract.getPuid()));
        contractWrapper.setCoursePack(this.coursePackService.getCoursePackWrapper(school.getBrandId(), school.getProv(), school.getCity(), schoolId, contract.getCoursePackId()));
        List<Integer> courseIds = this.coursePackService.getCoursesByPackId(school.getBrandId(), school.getProv(), school.getCity(), schoolId, contract.getCoursePackId());
        if (ArrayMapTools.isNotEmpty(courseIds)) {
            Map<Integer, CourseWrapper> courseMap = this.courseService.mutiGetCourseInfoMap(school.getBrandId(), courseIds);
            if (ArrayMapTools.isNotEmpty(courseIds)) {
                contractWrapper.setCourses(OrderTool.keepOrder(courseIds, courseMap.values(), CourseWrapper::getCourseId));
            }
        }
        HashSet fuids = Sets.newHashSet();
        if (StringUtils.isNotEmpty((CharSequence)contract.getAdviser())) {
            fuids.add(contract.getAdviser());
        }
        if (StringUtils.isNotEmpty((CharSequence)contract.getAdviser2())) {
            fuids.add(contract.getAdviser2());
        }
        if (StringUtils.isNotEmpty((CharSequence)contract.getTeacher())) {
            fuids.add(contract.getTeacher());
        }
        if (StringUtils.isNotEmpty((CharSequence)contract.getTeacher2())) {
            fuids.add(contract.getTeacher2());
        }
        if (StringUtils.isNotEmpty((CharSequence)contract.getMarket())) {
            fuids.add(contract.getMarket());
        }
        Map<String, UserSimpleWrapper> userMap = null;
        if (ArrayMapTools.isNotEmpty((Collection)fuids)) {
            userMap = this.fUserInfoService.mutiGetUserWrappers(fuids);
        }
        if (StringUtils.isNotEmpty((CharSequence)contract.getAdviser())) {
            contractWrapper.setAdviser(userMap.get(contract.getAdviser()));
        }
        if (StringUtils.isNotEmpty((CharSequence)contract.getAdviser2())) {
            contractWrapper.setAdviser2(userMap.get(contract.getAdviser2()));
            contractWrapper.setAdviser2Rat(contract.getAdviser2Rat());
        }
        if (StringUtils.isNotEmpty((CharSequence)contract.getTeacher())) {
            contractWrapper.setTeacher(userMap.get(contract.getTeacher()));
        }
        if (StringUtils.isNotEmpty((CharSequence)contract.getTeacher2())) {
            contractWrapper.setTeacher2(userMap.get(contract.getTeacher2()));
        }
        if (StringUtils.isNotEmpty((CharSequence)contract.getMarket())) {
            contractWrapper.setMarket(userMap.get(contract.getMarket()));
        }
        if (ArrayMapTools.isNotEmpty(postpones = this.contractPostponeRepository.getPayedPostpones(schoolId, contractId))) {
            ArrayList pps = Lists.newArrayList();
            for (ContractPostpone cp : postpones) {
                pps.add(ContractPostponeWrapper.of(cp));
            }
            contractWrapper.setPostpones(pps);
        }
        contractWrapper.setSerialNum(school.getCode() + "" + contract.getPayTime());
        contractWrapper.setParentSignContent(this.contractRepository.getParentSignContent(contractId));
        if (StringUtils.isNotEmpty((CharSequence)contractDetail.getTermId())) {
            contractWrapper.setTermsDetails(this.contractTermsRepository.getDetails(schoolId, contractDetail.getTermId()));
            ContractTerms ct = this.contractTermsRepository.getTerm(schoolId, contractDetail.getTermId());
            contractWrapper.setTermsRemark(ct != null ? ct.getRemark() : "");
            contractWrapper.setShowLessonNum(ct != null ? ct.getShowLessonNum() : 1);
        }
        if (StringUtils.isNotEmpty((CharSequence)contractDetail.getOriginStudents())) {
            contractWrapper.setOriginStudents(JSON.parseArray((String)contractDetail.getOriginStudents()));
        }
        SchoolWrapper schoolWrapper = SchoolWrapper.ofContract(school);
        if (contractDetail.getCompanyId() != null && (cc = this.contractCompanyService.getContractCompany(schoolId, contractDetail.getCompanyId())) != null) {
            schoolWrapper.setCompany(cc.getCompany()).setStamp(cc.getStamp());
        }
        return Pair.of((Object)contractWrapper, (Object)schoolWrapper);
    }

    public List<ContractWrapper> getParentContractList(String brandId, String puid, boolean needNoPay) {
        List<Contract> contracts = needNoPay ? this.contractRepository.getUserContractList(brandId, puid) : this.contractRepository.getPayedContractList(brandId, puid);
        ArrayList list = Lists.newArrayList();
        if (ArrayMapTools.isEmpty(contracts)) {
            return list;
        }
        List<String> contractIds = contracts.stream().map(it -> it.getContractId()).collect(Collectors.toList());
        List<StudentSchoolContract> sscs = this.studentSchoolContractRepository.mutiGetSSCByContractIds(contractIds);
        HashMap consumeOfficalLessonMap = Maps.newHashMap();
        HashMap noScheduleOfficalLessonMap = Maps.newHashMap();
        HashSet suids = Sets.newHashSet();
        HashMap contractId2Suids = Maps.newHashMap();
        HashSet schoolIds = Sets.newHashSet();
        for (StudentSchoolContract ssc : sscs) {
            suids.add(ssc.getSuid());
            schoolIds.add(ssc.getSchoolId());
            if (contractId2Suids.containsKey(ssc.getContractId())) {
                ((List)contractId2Suids.get(ssc.getContractId())).add(ssc.getSuid());
            } else {
                contractId2Suids.put(ssc.getContractId(), Lists.newArrayList((Object[])new String[]{ssc.getSuid()}));
            }
            consumeOfficalLessonMap.put(ssc.getContractId(), MapUtils.getIntValue((Map)consumeOfficalLessonMap, (Object)ssc.getContractId()) + ssc.getConsumeOfficalLesson());
            noScheduleOfficalLessonMap.put(ssc.getContractId(), MapUtils.getIntValue((Map)noScheduleOfficalLessonMap, (Object)ssc.getContractId()) + ssc.getNoScheduleOfficalLesson());
        }
        HashMap leftExtraLessonMap = Maps.newHashMap();
        HashMap consumeMap = Maps.newHashMap();
        List<StudentSchoolExtra> extras = this.studentSchoolContractRepository.mutiGetContractExtras(contractIds);
        if (ArrayMapTools.isNotEmpty(extras)) {
            for (StudentSchoolExtra extra : extras) {
                leftExtraLessonMap.put(extra.getContractId(), MapUtils.getIntValue((Map)leftExtraLessonMap, (Object)extra.getContractId()) + extra.getTotal() - extra.getConsume());
                consumeMap.put(extra.getContractId(), MapUtils.getIntValue((Map)consumeMap, (Object)extra.getContractId()) + extra.getConsume());
            }
        }
        Map<String, String> studentMap = this.studentInfoRepository.mutiGetSuid2NameMap(suids);
        HashMap contract2CdMap = Maps.newHashMap();
        HashSet termIds = Sets.newHashSet();
        List<ContractDetail> cds = this.contractRepository.mutiGetContractGiftCompany(contractIds);
        for (ContractDetail cd : cds) {
            contract2CdMap.put(cd.getContractId(), cd);
            if (cd.getTermId() == null) continue;
            termIds.add(cd.getTermId());
        }
        HashMap showLessonNumTable = Maps.newHashMap();
        List<ContractTerms> termss = this.contractTermsRepository.mutiGetShowLessonNum(schoolIds, termIds);
        for (ContractTerms t : termss) {
            if (!showLessonNumTable.containsKey(t.getSchoolId())) {
                showLessonNumTable.put(t.getSchoolId(), Maps.newHashMap());
            }
            ((Map)showLessonNumTable.get(t.getSchoolId())).put(t.getTermId(), t.getShowLessonNum());
        }
        Map<String, Map<Integer, String>> companyTable = this.contractCompanyService.mutiGetSchoolCompanyTable(schoolIds);
        List<String> postponeContractIds = this.contractPostponeRepository.filterPayedContractIds(contractIds);
        Map<String, String> schoolNameMap = this.schoolService.mutiGetId2NameMap(schoolIds);
        boolean haveNoOvertimeContract = false;
        long current = System.currentTimeMillis();
        for (Contract c : contracts) {
            ContractWrapper wrapper = ContractWrapper.of(c);
            wrapper.setSchoolName(schoolNameMap.get(c.getSchoolId()));
            int consumeOfficalLesson = MapUtils.getIntValue((Map)consumeOfficalLessonMap, (Object)c.getContractId());
            wrapper.setConsumeOfficalLesson(consumeOfficalLesson);
            wrapper.setNoScheduleOfficalLesson(MapUtils.getIntValue((Map)noScheduleOfficalLessonMap, (Object)c.getContractId()));
            int extraLeftLesson = MapUtils.getIntValue((Map)leftExtraLessonMap, (Object)c.getContractId());
            if (extraLeftLesson == 0 && c.getStatus() >= 10 && c.getStatus() < 20) {
                extraLeftLesson = c.getTotalExtraLesson();
            }
            wrapper.setExtraLeftLesson(extraLeftLesson);
            int totalLeftLesson = c.getTotalOfficalLesson() - consumeOfficalLesson + extraLeftLesson;
            wrapper.setTotalLeftLesson(totalLeftLesson);
            wrapper.setConsumeExtraLesson(MapUtils.getIntValue((Map)consumeMap, (Object)c.getContractId()));
            wrapper.setIsFinished(totalLeftLesson <= 0);
            String partyA = "";
            if (contractId2Suids.containsKey(c.getContractId())) {
                List childNames = ((List)contractId2Suids.get(c.getContractId())).stream().map(suid -> MapUtils.getString((Map)studentMap, (Object)suid, (String)"")).collect(Collectors.toList());
                partyA = StringUtils.join(childNames, (String)",");
            }
            wrapper.setPartyA(partyA);
            ContractDetail cd = (ContractDetail)contract2CdMap.get(c.getContractId());
            if (cd != null) {
                School school;
                Integer companyId = cd.getCompanyId();
                String partyB = "";
                if (companyTable.containsKey(c.getSchoolId())) {
                    partyB = MapUtils.getString(companyTable.get(c.getSchoolId()), (Object)companyId);
                }
                if (StringUtils.isEmpty((CharSequence)partyB) && (school = this.schoolService.getSchool(c.getSchoolId())) != null) {
                    partyB = school.getCompany();
                }
                wrapper.setPartyB(partyB);
                wrapper.setGiftName(cd.getGiftName());
                wrapper.setShowLessonNum(MapUtils.getIntValue((Map)((Map)showLessonNumTable.get(c.getSchoolId())), (Object)cd.getTermId()));
            }
            if (c.getStatus() == 3 || c.getStatus() == 4) {
                wrapper.setStatus(104);
            } else if (c.getStatus() == 5) {
                wrapper.setStatus(105);
            } else if (c.getStatus() == 2 || c.getStatus() >= 40 && c.getStatus() <= 49) {
                wrapper.setStatus(106);
            } else if (c.getStatus() >= 10 && c.getStatus() < 20) {
                if (c.getParentSignStatus() == ContractParentSignStatus.waitSignAffect.code && (c.getStatus() == 10 || c.getStatus() == 12 || c.getStatus() == 14 || c.getStatus() == 16 || c.getStatus() == 18)) {
                    wrapper.setStatus(100);
                } else {
                    wrapper.setStatus(101);
                }
            } else {
                wrapper.setStatus(totalLeftLesson <= 0 ? 103 : 102);
            }
            list.add(wrapper);
            if (wrapper.getStatus() != 102 || wrapper.getEndTime() != null && wrapper.getEndTime() <= current) continue;
            haveNoOvertimeContract = true;
        }
        for (ContractWrapper wrapper : list) {
            int displayStatus = 1;
            int displayLesson = 1;
            String tip = null;
            if (wrapper.getStatus() == 102) {
                if (wrapper.getEndTime() != null && wrapper.getEndTime() <= current) {
                    displayStatus = 2;
                    if (haveNoOvertimeContract) {
                        tip = wrapper.getScheType() == 1 ? "\u60a8\u7684\u5408\u540c\u5df2\u8fc7\u671f\u4e86\u5466\uff01" : "\u5408\u540c\u5df2\u8fc7\u671f\u8bf7\u5c3d\u5feb\u4e0a\u8bfe\u5466\uff01[\u597d\u597d\u5b66\u4e60\uff0c\u5929\u5929\u8fdb\u6b65\uff01]";
                    } else {
                        displayLesson = 2;
                    }
                } else if (postponeContractIds.contains(wrapper.getContractId())) {
                    displayStatus = 2;
                    tip = "\u672c\u5408\u540c\u6709\u6548\u671f\u5df2\u5e94\u60a8\u7533\u8bf7\u4e88\u4ee5\u5ef6\u957f\uff0c\u8bf7\u60a8\u73cd\u60dc\uff0c\u5e76\u5728\u671f\u9650\u5185\u5feb\u53bb\u60a8\u6821\u533a\u4e0a\u8bfe\u5427\uff5e";
                }
                if (wrapper.getEndTime() == null) {
                    displayStatus = 2;
                }
            } else if (wrapper.getStatus() == 104 || wrapper.getStatus() == 105) {
                displayLesson = 2;
            }
            if (displayLesson == 1) {
                if (wrapper.getTotalLeftLesson() <= 0 || wrapper.getEndTime() != null && wrapper.getEndTime() <= current) {
                    displayLesson = 2;
                } else if (wrapper.getScheType() == 1) {
                    displayLesson = wrapper.getShowLessonNum() != null && wrapper.getShowLessonNum() == 1 ? 3 : 2;
                }
            }
            wrapper.setDisplayStatus(displayStatus);
            wrapper.setDisplayLesson(displayLesson);
            wrapper.setTip(tip);
            if (!postponeContractIds.contains(wrapper.getContractId()) || wrapper.getStartTime() == null) continue;
            wrapper.setPostponeEndTime(wrapper.getEndTime());
            int days = wrapper.getDays();
            if (wrapper.getGiftDays() != null && wrapper.getGiftDays() > 0) {
                days += wrapper.getGiftDays().intValue();
            }
            wrapper.setEndTime(wrapper.getStartTime() + 86400000L * (long)days);
        }
        return list;
    }

    public boolean isHaveContract(String brandId, String puid) {
        List<String> schoolIds = this.contractRepository.getHaveContractSchoolIds(brandId, puid);
        if (ArrayMapTools.isEmpty(schoolIds)) {
            return false;
        }
        List<String> normalSchoolIds = this.schoolService.filterCalContractSchoolIds(schoolIds);
        if (ArrayMapTools.isEmpty(normalSchoolIds)) {
            return false;
        }
        List<String> suids = this.studentInfoRepository.getAllSuidsByPuid(puid);
        if (ArrayMapTools.isEmpty(suids)) {
            return false;
        }
        return this.studentSchoolService.checkIsReading(normalSchoolIds, suids);
    }

    public boolean isOwnedContract(String branchId, String puid) {
        return this.contractRepository.isOwnedContract(branchId, puid);
    }

    public boolean isHaveContractInSchool(String schoolId, String puid) {
        return this.contractRepository.isHaveContractInSchool(schoolId, puid);
    }

    public List<String> getContractedSchoolIds(String brandId, String puid) {
        return this.contractRepository.getContractedSchoolIds(brandId, puid);
    }

    public Contract getSimpleContract(String contractId) {
        return this.contractRepository.getSimpleContract(contractId);
    }

    public int cntWaitSignForAppOpen(String brandId, String puid) {
        return this.contractRepository.cntWaitParentSignForAppOpen(brandId, puid);
    }

    public List<String> getSchoolIds(String brandId, String puid) {
        return this.contractRepository.getSchoolIds(brandId, puid);
    }

    public boolean checkIsHaveContractAllBrand(String puid) {
        return this.contractRepository.checkIsHaveContractAllBrand(puid);
    }

    public String getContractedSchoolId(String brandId, String puid) {
        return this.contractRepository.getContractedSchoolId(brandId, puid);
    }

    public String getSuidRecentSchoolId(Collection<String> contractIds, String brand) {
        return this.contractRepository.getSuidRecentSchoolId(contractIds, brand);
    }
}

